/***************************************************************************
 *                                                                         *
 *   SYNLOOK.H                                                             *
 *                                                                         *
 *   Copyright (c) 2002 HSI Software, Inc.        All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module lookup alternate email request          *
 *   synthesis class.                                                      *
 *                                                                         *
 *                                            - J. Alvrus   07/24/2002     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__SYNLOOK_H)
#define __SYNLOOK_H

#include "gcomm.h"
#include "galacth.h"
#include "majorbbs.h"
#include "synbase.h"

class synLook : public synBase {   // email lookup request handler
public:
     synLook(                      // constructor
     acthSession * ses);           //   associated session object

     ~synLook();

     ACTHCODE                      //   returns enumerated status value
     proceed();                    // agent's request handler

private:                           // private member functions

     void
     setErrorVariable();           // set the error message text variable

private:                           // private data members
     enum {                        //   error codes
          ERR_NONE=0,              //     no error has occurred
          ERR_NOEML=1,             //     email address not specified
          ERR_BADEML=2             //     email address not found
     } m_err;                      //   error code
     CHAR * m_origdest;            //   value of origdest parameter
     CHAR m_eml[ALTEMLSIZ];        //   buffer for email address
};

#endif // !defined(__SYNLOOK_H)
