/***************************************************************************
 *                                                                         *
 *   SYNLOOK.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 2002 HSI Software, Inc.        All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module lookup alternate email request          *
 *   synthesis class.                                                      *
 *                                                                         *
 *                                            - J. Alvrus   07/24/2002     *
 *                                                                         *
 ***************************************************************************/

#include "synlook.h"
#include "wgsuext.h"
#include "dnfmgr.h"
#include "sesutil.h"
#include "tvbutil.h"
#include "tcpip.h"
#include "galsesah.h"

#define FILREV "$Revision: 1 $"
MARKSOURCE(synlook)

synLook::synLook(                  // constructor
acthSession *ses) :                //   associated session object
     synBase(ses),
     m_err(ERR_NONE),
     m_origdest(NULL)
{
     *m_eml='\0';
}

ACTHCODE
synLook::proceed()
{
     ACTHCODE rc=ACTHMORE;         // function return code

     for (bool go=startProc() ; go ; go=contProc(rc)) {
          if (m_dnf == NULL) {
               // check URL syntax
               if (ses->urlargc() == 1 && ses->forceDir()) {
                    return(ACTHDONE);
               }

               // read parameters
               size_t len=ses->paramRoom("origdest");
               if (len > 1) {
                    m_origdest=new CHAR[len];
                    ses->param("origdest",m_origdest,len);
               }

               struct uaccext ext;
               ::dfaSetBlk(::dfaUserExt);
               if (!ses->param("eml",m_eml,ALTEMLSIZ) || *m_eml == '\0') {
                    m_err=ERR_NOEML;
               }
               else if (!dfaAcqEQ(&ext,m_eml,1)) {
                    m_err=ERR_BADEML;
               }
               else {
                    ::stlcpy(m_eml,ext.alteml,ALTEMLSIZ);
               }
               ::dfaRstBlk();

               // look up user info and send the email
               struct in_addr ip;
               ip.s_addr=ses->clientIP();
               ::shocst("USERID/PWD REQUESTED BY EMAIL"
                       ,"IP: %s Email: %s",inet_ntoa(ip),m_eml);
               if (m_err == ERR_NONE) {
                    struct usracc acc;
                    ::dfaSetBlk(accbb);
                    if (::dfaAcqEQ(&acc,ext.userid,0)) {
                         ::SendPwdEmail(m_eml,acc.userid,acc.psword);
                    }
                    else {
                         m_err=ERR_BADEML;
                    }
                    ::dfaRstBlk();
               }

               // prepare response
               CHAR const * pTemplateFile;
               if (m_err == ERR_NONE) {
                    if (ses->urlargc() == 2) {    // "/lookup/foo.htm"
                         pTemplateFile=ses->urlargv(1);
                    }
                    else {
                         pTemplateFile="index.htm";
                    }
               }
               else {
                    pTemplateFile="error.htm";
               }
               CHAR sTemplatePath[GCMAXPTH];
               ::makePath(sTemplatePath,PPFIX "lookup",pTemplateFile,GCMAXPTH);
               m_dnf=::dnfCreateHandler(&bout,&baseMap,sTemplatePath);
          }

          // set up text variables
          tvbOnSuccess.set(m_origdest);
          dnfSetTemplateTvb(m_dnf);
          setErrorVariable();

          // generate some output
          if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }

          // clear text variables
          tvbOnSuccess.clr();
          dnfClearTemplateTvb();
          tvbErrMsg.clr();
     }
     return(rc);
}

void
synLook::setErrorVariable()        // set the error message text variable
{
     if (m_err == ERR_NONE) {
          tvbErrMsg.clr();
     }
     else {
          ::setmbk(g_hmcvSes);
          INT iMsgNum=ERRUNK;
          switch (m_err) {
          case ERR_NOEML:     iMsgNum=ERRNOEML; break;
          case ERR_BADEML:    iMsgNum=ERRBADEM; break;
          }
          ::clrprf();
          ::prfmsg(iMsgNum);
          tvbErrMsg.set(::stpans(::prfbuf));
          ::rstmbk();
     }
}

synLook::~synLook()
{
     if (m_origdest != NULL) {
          delete [] m_origdest;
          m_origdest=NULL;
     }
}
