/***************************************************************************
 *                                                                         *
 *   SYNLOGON.H                                                            *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module log on request synthesis class.         *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__SYNLOGON_H)
#define __SYNLOGON_H

#include "gcomm.h"
#include "galacth.h"
#include "majorbbs.h"
#include "synbase.h"

class synLogOn : public synBase {  // log on request handler
public:
     synLogOn(                     // constructor
     acthSession * ses,            //   associated session object
     INT UrlLevel,                 //   URL argument level
     bool CheckAlready);           //   check if already logged on?

     ~synLogOn();

     ACTHCODE                      //   returns enumerated status value
     proceed();                    // agent's request handler

private:
     synLogOn(acthSession * ses);  // no standard constructor

private:                           // private member functions

     ACTHCODE
     PrepLogOnSuccessResp();       // prepare success response to log on URL

     ACTHCODE
     PrepLogOnErrorResp();         // prepare response to log off URL

     CHAR *                        //   resp in parsed m_onerror; NULL if none
     FindOnErrorTemplate();        // find error-specific response in onerror

private:                           // private data members
     CHAR * m_onsuccess;           //   value of onsuccess parameter
     CHAR * m_onerror;             //   value of onerror parameter
     CHAR * m_mask;                //   custom template mask
     INT m_level;                  //   URL arg level (e.g., "/logon" == 1)
     enum {                        //   processing state codes
          ST_START,                //     starting
          ST_CHECKLOG,             //     check log in info
          ST_PREPRESP,             //     prepare for response
          ST_OUTPUT                //     generate output
     } m_state;                    //   processing state
     enum {                        //   error codes
          ERR_NONE=0,              //     no error has occurred
          ERR_NOUID=1,             //     User-ID not specified
          ERR_BADUID=2,            //     User-ID does not exist
          ERR_NOPWD=3,             //     password not specified
          ERR_BADPWD=4             //     password is not correct
     } m_err;                      //   error code
     bool m_already;               //   check if already logged in?
     CHAR m_uid[UIDSIZ];           //   buffer for User-ID
     CHAR m_pwd[PSWSIZ];           //   buffer for password
};

#endif // !defined(__SYNLOGON_H)
