/***************************************************************************
 *                                                                         *
 *   SYNLOGOF.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module log off request synthesis class.        *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#include "synlogof.h"
#include "dnfmgr.h"
#include "sesutil.h"

#define FILREV "$Revision: 1 $"
MARKSOURCE(synlogof)

synLogOff::synLogOff(
acthSession *ses) :
     synBase(ses)
{
}

ACTHCODE
synLogOff::proceed()
{

     if (m_dnf == NULL) {

          // check URL syntax
          if (ses->urlargc() == 1 && ses->forceDir()) {
               return(ACTHDONE);
          }

          // set up response
          ACTHCODE rc;
          if (ses->getUserAuthType() == AT_COOKIE) {
               rc=PrepLogOffResponse("index.htm",true,"onsuccess");
          }
          else {
               rc=PrepLogOffResponse("error.htm",false,"onerror");
          }
          if (rc != ACTHMORE) {
               return(rc);
          }
     }
     return(dnfProcess());
}

ACTHCODE
synLogOff::PrepLogOffResponse(     // prepare response to log off URL
CHAR const * DefaultTemplate,      //   default response template
bool UseCustomTemplate,            //   custom template overrides default?
CHAR const * OverrideParam)        //   parameter that overrides default resp.
{
     ACTHCODE rc=ACTHMORE;

     // get response template
     CHAR const * TemplateFile=DefaultTemplate;
     bool DelTemplate=false;
     if (UseCustomTemplate && ses->urlargc() == 2) {   // "/logout/foo.htm"
          TemplateFile=ses->urlargv(1);
     }

     // check for parameter override
     size_t len=ses->paramRoom(OverrideParam);
     if (len > 1) {
          TemplateFile=new CHAR[len];
          DelTemplate=true;
          ses->param(OverrideParam,const_cast<CHAR *>(TemplateFile),len);
     }

     // redirect or create DynaFile
     if (::isRedirectLocation(TemplateFile)) {

          // make sure location is fully qualified
          if (TemplateFile[0] == '/') {
               ostrstream ost;
               ost << "http://" << ses->host() << TemplateFile << ends;
               if (DelTemplate) {
                    delete[] TemplateFile;
               }
               TemplateFile=ost.str();
               DelTemplate=true;
          }

          // generate redirection response
          ses->setStatus("302 Redirect");
          ses->headerField("Location",TemplateFile);
          ses->clrUser();
          bout << "<html>" << crlf
               << "<head><title>Request Redirected</title></head>" << crlf
               << "<body>" << crlf
               << "Request redirected to: <a href=\""
               << TemplateFile << "\">"
               << TemplateFile << "</a>" << crlf
               << "</body></html>";

          rc=ACTHDONE;
     }
     else {

          // create DynaFile handler
          CHAR TemplatePath[GCMAXPTH];
          makePath(TemplatePath,PPFIX "logout",TemplateFile,GCMAXPTH);
          m_dnf=dnfCreateHandler(&bout,&baseMap,TemplatePath);

          // clear authentication cookie
          ses->clrUser();
     }

     if (DelTemplate) {
          delete [] TemplateFile;
     }
     return(rc);
}

synLogOff::~synLogOff()
{
}
