/***************************************************************************
 *                                                                         *
 *   SYNHINT.H                                                             *
 *                                                                         *
 *   Copyright (c) 2002 HSI Software, Inc.        All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module show password hint request synthesis    *
 *   class.                                                                *
 *                                                                         *
 *                                            - J. Alvrus   07/24/2002     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__SYNHINT_H)
#define __SYNHINT_H

#include "gcomm.h"
#include "galacth.h"
#include "majorbbs.h"
#include "synbase.h"

class synHint : public synBase {   // log on request handler
public:
     synHint(                      // constructor
     acthSession * ses);           //   associated session object

     ~synHint();

     ACTHCODE                      //   returns enumerated status value
     proceed();                    // agent's request handler

private:                           // private member functions

     void
     setErrorVariable();           // set the error message text variable

private:                           // private data members
     enum {                        //   error codes
          ERR_NONE=0,              //     no error has occurred
          ERR_NOUID=1,             //     User-ID not specified
          ERR_BADUID=2,            //     User-ID does not exist
          ERR_NOHINT=3             //     no password hint saved
     } m_err;                      //   error code
     CHAR * m_origdest;            //   value of origdest parameter
     CHAR m_uid[UIDSIZ];           //   buffer for User-ID
     CHAR m_hint[HINTSIZ];         //   buffer for password hint
};

#endif // !defined(__SYNHINT_H)
