/***************************************************************************
 *                                                                         *
 *   SYNHINT.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 2002 HSI Software, Inc.        All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module show password hint request synthesis    *
 *   class.                                                                *
 *                                                                         *
 *                                            - J. Alvrus   07/24/2002     *
 *                                                                         *
 ***************************************************************************/

#include "synhint.h"
#include "wgsuext.h"
#include "dnfmgr.h"
#include "sesutil.h"
#include "tvbutil.h"
#include "tcpip.h"
#include "galsesah.h"

#define FILREV "$Revision: 1 $"
MARKSOURCE(synhint)

tvbBase tvbHint("SES_PASSWORDHINT"); // password hint text variable

synHint::synHint(                  // constructor
acthSession *ses) :                //   associated session object
     synBase(ses),
     m_err(ERR_NONE),
     m_origdest(NULL)
{
     *m_uid='\0';
     *m_hint='\0';
}

ACTHCODE
synHint::proceed()
{
     ACTHCODE rc=ACTHMORE;         // function return code

     for (bool go=startProc() ; go ; go=contProc(rc)) {
          if (m_dnf == NULL) {
               // check URL syntax
               if (ses->urlargc() == 1 && ses->forceDir()) {
                    return(ACTHDONE);
               }

               // read parameters
               size_t len=ses->paramRoom("origdest");
               if (len > 1) {
                    m_origdest=new CHAR[len];
                    ses->param("origdest",m_origdest,len);
               }

               struct usracc acc;
               dfaSetBlk(accbb);
               if (!ses->param("uid",m_uid,UIDSIZ) || *m_uid == '\0') {
                    m_err=ERR_NOUID;
               }
               else if (!dfaAcqEQ(&acc,m_uid,0)) {
                    m_err=ERR_BADUID;
               }
               else {
                    ::stlcpy(m_uid,acc.userid,UIDSIZ);
               }
               dfaRstBlk();

               // look up hint
               struct in_addr ip;
               ip.s_addr=ses->clientIP();
               ::shocst("PASSWORD HINT REQUESTED"
                       ,"IP: %s UID: %s",inet_ntoa(ip),m_uid);
               if (m_err == ERR_NONE) {
                    struct uaccext ext;
                    ::dfaSetBlk(::dfaUserExt);
                    if (dfaAcqEQ(&ext,m_uid,0) && *ext.pwdhint != '\0') {
                         ::stlcpy(m_hint,ext.pwdhint,HINTSIZ);
                    }
                    else {
                         m_err=ERR_NOHINT;
                    }
                    ::dfaRstBlk();
               }

               // prepare response
               CHAR const * pTemplateFile;
               if (m_err == ERR_NONE) {
                    if (ses->urlargc() == 2) {    // "/hint/foo.htm"
                         pTemplateFile=ses->urlargv(1);
                    }
                    else {
                         pTemplateFile="index.htm";
                    }
               }
               else {
                    pTemplateFile="error.htm";
               }
               CHAR sTemplatePath[GCMAXPTH];
               ::makePath(sTemplatePath,PPFIX "hint",pTemplateFile,GCMAXPTH);
               m_dnf=::dnfCreateHandler(&bout,&baseMap,sTemplatePath);
          }

          // set up text variables
          tvbUserID.set(m_uid);
          tvbHint.set(m_hint);
          tvbOnSuccess.set(m_origdest);
          dnfSetTemplateTvb(m_dnf);
          setErrorVariable();

          // generate some output
          if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }

          // clear text variables
          tvbUserID.clr();
          tvbHint.clr();
          tvbOnSuccess.clr();
          dnfClearTemplateTvb();
          tvbErrMsg.clr();
     }
     return(rc);
}

void
synHint::setErrorVariable()        // set the error message text variable
{
     if (m_err == ERR_NONE) {
          tvbErrMsg.clr();
     }
     else {
          ::setmbk(g_hmcvSes);
          INT iMsgNum=ERRUNK;
          switch (m_err) {
          case ERR_NOUID:     iMsgNum=ERRNOUID; break;
          case ERR_BADUID:    iMsgNum=ERRBADID; break;
          case ERR_NOHINT:    iMsgNum=ERRNOHIN; break;
          }
          ::clrprf();
          ::prfmsg(iMsgNum);
          tvbErrMsg.set(::stpans(::prfbuf));
          ::rstmbk();
     }
}

synHint::~synHint()
{
     if (m_origdest != NULL) {
          delete [] m_origdest;
          m_origdest=NULL;
     }
}
