/***************************************************************************
 *                                                                         *
 *   SYNEMAIL.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 2002 HSI Software, Inc.        All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module email passwrod request synthesis class. *
 *                                                                         *
 *                                            - J. Alvrus   07/24/2002     *
 *                                                                         *
 ***************************************************************************/

#include "synemail.h"
#include "wgsuext.h"
#include "dnfmgr.h"
#include "sesutil.h"
#include "tvbutil.h"
#include "tcpip.h"
#include "galsesah.h"

#define FILREV "$Revision: 1 $"
MARKSOURCE(synemail)

synEmail::synEmail(                // constructor
acthSession *ses) :                //   associated session object
     synBase(ses),
     m_err(ERR_NONE),
     m_origdest(NULL)
{
     *m_uid='\0';
}

ACTHCODE
synEmail::proceed()
{
     ACTHCODE rc=ACTHMORE;         // function return code

     for (bool go=startProc() ; go ; go=contProc(rc)) {
          if (m_dnf == NULL) {
               // check URL syntax
               if (ses->urlargc() == 1 && ses->forceDir()) {
                    return(ACTHDONE);
               }

               // read parameters
               size_t len=ses->paramRoom("origdest");
               if (len > 1) {
                    m_origdest=new CHAR[len];
                    ses->param("origdest",m_origdest,len);
               }

               struct usracc acc;
               dfaSetBlk(accbb);
               if (!ses->param("uid",m_uid,UIDSIZ) || *m_uid == '\0') {
                    m_err=ERR_NOUID;
               }
               else if (!dfaAcqEQ(&acc,m_uid,0)) {
                    m_err=ERR_BADUID;
               }
               else {
                    ::stlcpy(m_uid,acc.userid,UIDSIZ);
               }
               dfaRstBlk();

               // look up email address, and send if possible
               struct in_addr ip;
               ip.s_addr=ses->clientIP();
               ::shocst("PASSWORD REQUESTED BY USER-ID"
                       ,"IP: %s UID: %s",inet_ntoa(ip),m_uid);
               if (m_err == ERR_NONE) {
                    struct uaccext ext;
                    ::dfaSetBlk(::dfaUserExt);
                    if (dfaAcqEQ(&ext,m_uid,0) && *ext.alteml != '\0') {
                         ::SendPwdEmail(ext.alteml,m_uid,acc.psword);
                    }
                    else {
                         m_err=ERR_NOEMAIL;
                    }
                    ::dfaRstBlk();
               }

               // prepare response
               CHAR const * pTemplateFile;
               if (m_err == ERR_NONE) {
                    if (ses->urlargc() == 2) {    // "/email/foo.htm"
                         pTemplateFile=ses->urlargv(1);
                    }
                    else {
                         pTemplateFile="index.htm";
                    }
               }
               else {
                    pTemplateFile="error.htm";
               }
               CHAR sTemplatePath[GCMAXPTH];
               ::makePath(sTemplatePath,PPFIX "email",pTemplateFile,GCMAXPTH);
               m_dnf=::dnfCreateHandler(&bout,&baseMap,sTemplatePath);
          }

          // set up text variables
          tvbUserID.set(m_uid);
          tvbOnSuccess.set(m_origdest);
          dnfSetTemplateTvb(m_dnf);
          setErrorVariable();

          // generate some output
          if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }

          // clear text variables
          tvbUserID.clr();
          tvbOnSuccess.clr();
          dnfClearTemplateTvb();
          tvbErrMsg.clr();
     }
     return(rc);
}

void
synEmail::setErrorVariable()       // set the error message text variable
{
     if (m_err == ERR_NONE) {
          tvbErrMsg.clr();
     }
     else {
          ::setmbk(g_hmcvSes);
          INT iMsgNum=ERRUNK;
          switch (m_err) {
          case ERR_NOUID:     iMsgNum=ERRNOUID; break;
          case ERR_BADUID:    iMsgNum=ERRBADID; break;
          case ERR_NOEMAIL:   iMsgNum=ERRNOALT; break;
          }
          ::clrprf();
          ::prfmsg(iMsgNum);
          tvbErrMsg.set(::stpans(::prfbuf));
          ::rstmbk();
     }
}

synEmail::~synEmail()
{
     if (m_origdest != NULL) {
          delete [] m_origdest;
          m_origdest=NULL;
     }
}
