/***************************************************************************
 *                                                                         *
 *   SYNBASE.H                                                             *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module request synthesis base class.           *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__SYNBASE_H)
#define __SYNBASE_H

#include "gcomm.h"
#include "galacth.h"
#include "dnf.h"
#include "cyctimer.h"

class synBase : public acthSynthesis { // virtual base class
public:
     synBase(
     acthSession *ses);

     ~synBase();

     virtual ACTHCODE              //   returns enumerated status value
     proceed()=0;                  // agent's request handler

protected:

     bool
     startProc();                  // start proceed() processing?

     bool
     contProc(                     // continue proceed() processing?
     ACTHCODE rc);                 //   current proceed() return code

     bool
     haveRoom();                   // do we have room for output?

     ACTHCODE
     dnfProcess();                 // standard DNF pumper

private:
     synBase();                    // no default constructor

     synBase(                      // no copy constructor
     synBase& hs);

     VOID
     operator=(                    // no assignment operator
     synBase& hs);

protected:                         // standard data members
     dnfHandler * m_dnf;           //   DynaFile handler
     cycleTimer m_timer;           //   cycle time slicer
};

extern dnfMap baseMap;             // generic map used by base class

#endif // !defined(__SYNBASE_H)
