/***************************************************************************
 *                                                                         *
 *   SYNBASE.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module request synthesis base class.           *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#include "synbase.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "majorbbs.h"
#include "brkthu.h"
#include "sesutil.h"

#define FILREV "$Revision: 1 $"
MARKSOURCE(synbase)

dnfStep baseStep[]={               // generic step array/map
     dnfStep(DNFMAPEND)
};
dnfMap baseMap(PPFIX "index.htm","Generic",baseStep);

synBase::synBase(
acthSession *ses) :
     acthSynthesis(ses),
     m_dnf(NULL),
     m_timer(TIMSLC)
{
}

bool
synBase::startProc()               // start proceed() processing?
{
     return(haveRoom() && m_timer.start());
}

bool
synBase::contProc(                 // continue proceed() processing?
ACTHCODE rc)                       //   current proceed() return code
{
     return(rc == ACTHMORE && haveRoom() && m_timer.haveTime());
}

bool
synBase::haveRoom()                // do we have room for output?
{
     // leave 512 bytes breathing room in output buffer
     return(::btuoba(::usrnum) > 512);
}

ACTHCODE
synBase::dnfProcess()              // standard DNF pumper
{
     ACTHCODE rc=ACTHMORE;

     dnfSetTemplateTvb(m_dnf);
     for (bool go=startProc() ; go ; go=contProc(rc)) {
          if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }
     }
     dnfClearTemplateTvb();
     return(rc);
}

synBase::~synBase()
{
     if (m_dnf != NULL) {
          delete m_dnf;
          m_dnf=NULL;
     }
}
