/***************************************************************************
 *                                                                         *
 *   SYNBADRQ.H                                                            *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module bad request handler.                    *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__SYNBADRQ_H)
#define __SYNBADRQ_H

#include "gcomm.h"
#include "galacth.h"

class synBadRequest : public acthSynthesis { // bad request handler
public:
     synBadRequest(
     acthSession *ses,
     ACTHCODE rc) :
          acthSynthesis(ses),
          m_rc(rc)
     {}

     ACTHCODE                      //   returns enumerated status value
     proceed()                     // agent's request handler
     {
          return(m_rc);
     }

private:                           // private member functions

     synBadRequest(                // no standard synthesis constructor
     acthSession *ses);

private:                           // private data members
     ACTHCODE m_rc;                //   what's wrong with request
};

#endif // !defined(__SYNBADRQ_H)
