/***************************************************************************
 *                                                                         *
 *   ENCUTIL.H                                                             *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Utilities for HTML/URL encoding output.                               *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__ENCUTIL_H)
#define __ENCUTIL_H

#include "gcomm.h"

CHAR *                             //   returns allocated buffer
urlEncodeStr(                      // encode special characters in a URL
const CHAR *src);                  //   unencoded URL

size_t
urlEncodeSize(                     // size of encoded URL (incl '\0')
const CHAR *src);                  //   unencoded URL

CHAR *                             //   returns pointer to destination
urlEncodeBuf(                      // encode special characters in URL
CHAR *buf,                         //   buffer to receive encoded string
const CHAR *src,                   //   unencoded URL
size_t bufSiz);                    //   size of destination buffer

CHAR *                             //   returns pointer to destination
urlDecodeBuf(                      // decode special characters in URL
CHAR *buf,                         //   buffer to receive decoded string
const CHAR *src,                   //   unencoded URL
size_t bufSiz);                    //   size of destination buffer

bool
urlNeedEncode(                     // does this character need to be encoded?
CHAR c);                           //   character to check

CHAR *                             //   returns allocated buffer
entEncodeStr(                      // encode entities in a string
const CHAR *src);                  //   unencoded string

size_t
entSize(                           // size of entity-encoded string (incl '\0')
const CHAR *src);                  //   unencoded string

CHAR *                             //   returns pointer to destination
entEncodeBuf(                      // encode string using HTML entities
CHAR *buf,                         //   buffer to receive encoded string
const CHAR *src,                   //   unencoded string
size_t bufSiz);                    //   size of destination buffer

#endif // !defined(__ENCUTIL_H)
