/***************************************************************************
 *                                                                         *
 *   GALSCW.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997      Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Secure Web.                                                           *
 *                                                                         *
 *                                                   - N. C. Osterc        *
 *                                                                         *
 ***************************************************************************/

#ifndef __GALSCW_H
#define __GALSCW_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef GCWINNT
#ifdef __BUILDSECWEB
#define SCWEXP _export
#else  // __BUILDSECWEB
#define SCWEXP _import
#endif // __BUILDSECWEB
#else // GWINNT
#define SCWEXP
#endif // GCWINNT

#define LINKSIZ 255                // Maximum size of a link
#define PWDSIZ 16                  // Max size of password
#define KEYLEN 16                  // Max size of key

extern DFAFILE* SCWEXP scwbb;      // secure web database pointer

extern GBOOL SCWEXP               
IsDirSecure(                       // directory/page is secure?
const CHAR *link);                 // link in question

struct secwebdat {          // secure web structure
     CHAR dpname[LINKSIZ];         // link
     CHAR keynam[KEYLEN];          // key
     CHAR psword[PWDSIZ];          // password
};

extern struct secwebdat SCWEXP sw;

#ifdef __cplusplus
}; //extern "C"
#endif // __cplusplus

#endif                             // __GALSCW_H
