/***************************************************************************
 *                                                                         *
 *   RLOGIND.H                                                             *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Rlogin daemon for Worldgroup.                                         *
 *                                                                         *
 *                                        - Craig Yap  5/23/95             *
 *                                                                         *
 ***************************************************************************/

#ifndef __RLOGIND_H
#define __RLOGIND_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined(GCWINNT)
#ifdef __BUILDRLOGIND
#define RLGNDEXP __export
#else
#define RLGNDEXP __import
#endif                             /* __BUILDRLOGIND                       */
#else
#define RLGNDEXP
#endif                             /* GCWINNT                              */

#define LGNPORT 513                /* TCP/IP port for Rlogin servers       */
#define LGNNAME "Rlogin"           /* name of server                       */
#define LGNBACKLOG 5               /* max # of colliding incoming calls    */
#define TNMLEN  6                  /* max length for incoming terminal name*/
#define NNULSR  4                  /* number of required NULs to begin     */
#define MAXB4N  512                /* max bytes before all NULs received   */

struct lgndinf {                   /* Rlogin/channel info                  */
     INT nnuls;                    /* number of NULs received so far       */
     INT nbsofar;                  /* number of bytes read so far          */
     UCHAR flags;                  /* see LGNXXX flags below               */
     LONG bytlon;                  /* bturep(CNTCHR) at logon              */
};

extern
struct lgndinf * RLGNDEXP lgndinf; /* array of user/rlogin info            */

extern INT RLGNDEXP errcod;        /* error code used for connect refuse   */

                                   /*--- flag bits for lgndinf->flags -----*/
#define LGNCHN 0x01                /*   rlogin daemon controlling this chan*/

extern INT RLGNDEXP lgnunm;        /* lgnrdt() & subs: user number         */
extern struct tcpipinf * RLGNDEXP tiptr;/* lgnrdt() & subs: tcpip info for user */
extern INT RLGNDEXP rdtact;        /* set by tnordt(), actual # bytes recd */

VOID
lgnincall(                         /* begin incoming Rlogin session        */
INT gotchn);                       /* 1=chan (curusr) assigned, 0=not avail*/
                                   /* implicit:  clskt=socket to client    */

INT
lgndcnt(VOID);                     /* count of rlogin server connections   */

USHORT
lgnskw(                            /* snkwin() for Rlogin sessions         */
struct datstm *dsp);               /* DataStream structure                 */
                                   /* returns room in buffer               */

VOID
lgndmv(                            /* didmov() for Rlogin sessions         */
struct datstm *dsp,                /* DataStream structure                 */
USHORT nactual);                   /* this many were moved by the source   */

USHORT
lgnmit(                            /* moveit() for Rlogin sessions         */
struct datstm *dsp,                /* (pointer to sink's datstm structure) */
UCHAR *srcloc,                     /* source specifies the location        */
USHORT nwant);                     /* source wants sink to move this many  */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __RLOGIND_H
