/***************************************************************************
 *                                                                         *
 *   RLOGIN.H                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Rlogin client for Worldgroup.                                         *
 *                                                                         *
 *                                        - Craig Yap  5/23/95             *
 *                                                                         *
 ***************************************************************************/

#ifndef __RLOGIN_H
#define __RLOGIN_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define PRVPRT      1023           /* starting point for port checks       */
#define MAXLPS      3              /* number of bind retries per cycle     */
#define ESCSIZ      7              /* maximum size of escape string        */
#define HSTSIZ      256            /* maximum size of host name            */
#define LGNPORT     513            /* rlogin port number                   */
#define LGNSIZ      2048           /* rlogin buffer size                   */
#define USRSIZ      256            /* maximum size of remote User-ID       */

struct Winsize {                   /* local screen size structure          */
     USHORT ws_row;                /*   number of rows                     */
     USHORT ws_col;                /*   number of columns                  */
     USHORT ws_xpixel;             /*   number of horizontal pixels        */
     USHORT ws_ypixel;             /*   number of vertical pixels          */
};

struct lgninf {                    /* rlogin user information structure    */
     CHAR escape[ESCSIZ];          /*   escape string                      */
     CHAR luserid[UIDSIZ];         /*   local User-ID                      */
     CHAR ruserid[USRSIZ];         /*   remote User-ID                     */
     CHAR host[HSTSIZ];            /*   host name connected to             */
     CHAR buffer[LGNSIZ];          /*   information buffer                 */
     INT rcvwin;                   /*   recieve window size                */
     INT abtcnt;                   /*   abort string counter               */
     INT sockt;                    /*   socket number                      */
     UINT rport;                   /*   remote port                        */
     UINT lport;                   /*   local port                         */
     UINT bufcnt;                  /*   current buffer position            */
     USHORT sttime;                /*   starting time of connection        */
     USHORT abtclk;                /*   abort string timer                 */
     GBOOL alwescp;                /*   user allowed to escape?            */
     ULONG tckonl;                 /*   total connection time              */
     ULONG byttfc;                 /*   total number of bytes transferred  */
     struct dns dns;               /*   DNS information structure          */
};

#define lgnptr ((struct lgninf *)vdaptr)

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __RLOGIN_H
