/***************************************************************************
 *                                                                         *
 *   POP3UTIL.C                                                            *
 *                                                                         *
 *   Copyright (C) 1995-1997 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   Utility functions related to POP3.                                    *
 *                                                                         *
 *                               7/13/95 - Bert Love,                      *
 *                                         Charles Dunn &                  *
 *                                         Ilya Minkin                     *
 *                                                                         *
 ***************************************************************************/

#include <sys/timeb.h>
#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "tcpip.h"
#include "dns.h"
#include "smtpexp.h"
#include "pop3.h"

#define FILREV "$Revision: 7 $"

CHAR *
cvtdate(                           /* convert DOS date to RFC1036 format   */
SHORT dtim,
SHORT ddat)
{
     static CHAR mth[16][4]={"xxx","Jan","Feb","Mar","Apr","May","Jun",
                             "Jul","Aug","Sep","Oct","Nov","Dec","xxx",
                             "xxx","xxx"};
     return(spr("%d %s %d %s %s",
          ddday(ddat),mth[ddmon(ddat)],ddyear(ddat),
          nctime(dtim),smttmz));
}

VOID
logpop3(                           /* log receive transaction              */
CHAR *logstr,
INT type)
{
     FILE *logfp;
     CHAR wrkbuf[POP3LSZ];

     if (!pop3log) {
          return;
     }
     if ((logfp=fopen(pop3lnam,FOPAA)) == NULL) {
          pop3log=FALSE;
          shocst("POP3 RECEIVE LOG OPEN ERROR",
                 "Could not open \"%s\".  Logging disabled.",pop3lnam);
          return;
     }
     stzcpy(wrkbuf,logstr,POP3LSZ);
     if (fprintf(logfp,"%s %s: %s%s\n",ncdate(today()),nctime(now()),
                 type == OUTGING ? "-->" : type == INCMING ? "<--" : "***",
                 unpad(wrkbuf)) == EOF) {
          pop3log=FALSE;
          shocst("POP3 RECEIVE LOG WRITE ERROR",
                 "Could not write to receive log.  Logging disabled.");
     }
     fclose(logfp);
}

VOID
poplog(                           /* prints to audit trail, logs to file  */
CHAR *header,
CHAR *footer,
...)
{
     va_list ftlist;
     CHAR wrkbuf[POP3LSZ];
     CHAR logbuf[POP3LSZ*2];

     va_start(ftlist,footer);
     vsprintf(wrkbuf,footer,ftlist);
     va_end(ftlist);
     shocst(header,wrkbuf);
     sprintf(logbuf,"%s: %s",header,wrkbuf);
     logpop3(logbuf,SHOWLOG);
}
