/***************************************************************************
 *                                                                         *
 *   POP3.H                                                                *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   POP3 definitions and function prototypes for Worldgroup.              *
 *                                                                         *
 *                               7/13/95 - Bert Love,                      *
 *                                         Charles Dunn &                  *
 *                                         Ilya Minkin                     *
 *                                                                         *
 ***************************************************************************/

#ifndef __POP3_H
#define __POP3_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus


#define POP3NAM     "POP3"         /* name of POP3 server                  */
#define POP3BACKLOG 5              /* listen() backlog                     */
#define NUMLINS     50             /* maximum lines to read per cycle      */
#define DATESZ      81             /* maximum length of date               */
#define LINSIZ      80             /* UUENCODE line length                 */
#define POP3LSZ     (512+1)        /* POP3 maximum command/reply line size */

                                   /* log function codes                   */
#define INCMING   0                /*   incoming data                      */
#define OUTGING   1                /*   outgoing data                      */
#define SHOWLOG   2                /*   log entry via sholog()             */

CHAR *cvtdate(SHORT dtim,SHORT ddat);
VOID logpop3(CHAR *logstr,INT inout);
VOID poplog(CHAR *header,CHAR *footer,...);

extern GBOOL pop3log;              /*   is receive log currently active?   */
extern CHAR *pop3lnam;             /*   receive log file name              */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __POP3_H
