/***************************************************************************
 *                                                                         *
 *   MD5UTIL.H                                                             *
 *                                                                         *
 *   MD5 Message Digest algorithm functions header file                    *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.                             *
 *                                                                         *
 *                               7/20/95 - Bert Love,                      *
 *                                         Charles Dunn &                  *
 *                                         Ilya Minkin                     *
 *                                                                         *
 * Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All         *
 * rights reserved.                                                        *
 *                                                                         *
 * License to copy and use this software is granted provided that it       *
 * is identified as the "RSA Data Security, Inc. MD5 Message-Digest        *
 * Algorithm" in all material mentioning or referencing this software      *
 * or this function.                                                       *
 *                                                                         *
 * License is also granted to make and use derivative works provided       *
 * that such works are identified as "derived from the RSA Data            *
 * Security, Inc. MD5 Message-Digest Algorithm" in all material            *
 * mentioning or referencing the derived work.                             *
 *                                                                         *
 * RSA Data Security, Inc. makes no representations concerning either      *
 * the merchantability of this software or the suitability of this         *
 * software for any particular purpose. It is provided "as is"             *
 * without express or implied warranty of any kind.                        *
 *                                                                         *
 * These notices must be retained in any copies of any part of this        *
 * documentation and/or software.                                          *
 *                                                                         *
 ***************************************************************************/

#ifndef __MD5UTIL_H
#define __MD5UTIL_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus


typedef ULONG UINT4;               // UINT4 defines a four byte word

typedef struct {
  UINT4 state[4];                  // state (ABCD)
  UINT4 count[2];                  // number of bits, modulo 2^64 (lsb first)
  CHAR buffer[64];                 // input buffer
} MD5_CTX;

#define MD5SIZ 33                  // size of MD5 digest as hex string

CHAR *                             //   MD5 digest as lower case hex str
strmd5(                            // calculate msg digest for "string"
CHAR *string);                     //   string to digest

VOID
inimd5(                            // initialize MD5 context
MD5_CTX *context);

VOID
updmd5(                            // update message digest with input str
MD5_CTX *context,
CHAR *input,
UINT inputLen);

VOID
finmd5(                            // finish up and return MD5 digest
CHAR digest[16],
MD5_CTX *context);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __MD5UTIL_H
