/***************************************************************************
 *                                                                         *
 *   NNTP.H                                                                *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   NNTP definitions and function prototypes for Worldgroup.              *
 *                                                                         *
 *                               6/26/95 - Bert Love,                      *
 *                                         Ilya Minkin &                   *
 *                                         Charles Dunn                    *
 *                                                                         *
 ***************************************************************************/

#ifndef __NNTP_H
#define __NNTP_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define NNTPORT     119            /* NNTP port                            */
#define NNTNAME     "NNTP"         /* name of NNTP server                  */
#define NNTBACKLOG  5              /* listen() backlog                     */
#define NUMLINS     50             /* maximum lines to read per cycle      */
#define DATESZ      81             /* maximum length of date               */
#define LINSIZ      80             /* UUENCODE line length                 */
#define NNTLSZ      (512+1)        /* NNTP maximum command/reply line size */
#define NNTTSZ      (1000+1)       /* NNTP maximum text line size          */
#define MIDSIZ      256            /* maximum size of message ID string    */
#define QNMSIZ      8              /* maximum size of qinfo name hdr       */
#define LASTI       0xFFFFFFFFUL   /* last message index                   */
#define NNTPSECTHDR "USENET Headers" /* app-info section for headers       */

                                   /* message ID data file key numbers     */
#define MIDKEY 0                   /*   message ID crc key                 */
#define FIDKEY 1                   /*   forum+counter key                  */
#define MSGKEY 2                   /*   GME global ID key                  */

#define ENC(c) (((c) & 077) + ' ') /* UUENCODE byte manipulation           */

struct midinf {                    /* NNTP message information structure   */
     struct globid globid;         /*   GME global identifier              */
     ULONG midcrc;                 /*   32 bit CRC of message ID string    */
     ULONG msgidx;                 /*   message # in the forum (index)     */
     LONG thrid;                   /*   GME thread ID                      */
     LONG timadd;                  /*   time (in seconds) msg was added    */
     USHORT forum;                 /*   ID of forum message belongs to     */
     CHAR midstr[MIDSIZ];          /*   actual message ID string           */
};

struct cmpkey {                    /* FIDKEY composite key                 */
     USHORT forum;                 /*   ID of forum message belongs to     */
     ULONG msgidx;                 /*   message # in the forum (index)     */
};

static struct qinfo {              /* queue info header in message file    */
     CHAR name[QNMSIZ];            /*   sanity check for NNTP outbnd msgs  */
     time_t qtime;                 /*   time msg was queued for NNTP       */
     time_t lsttim;                /*   time of last try                   */
     CHAR attfil[GCMAXPTH];        /*   file attachment path               */
     CHAR relnam[GCMAXFNM];        /*   user-specified name for attachment */
     CHAR id[MIDSIZ];              /*   Internet message-id                */
     CHAR to[MAXADR];              /*   To: address                        */
};

extern DFAFILE *midbb;             /* btrieve pointer to message ID data   */
extern CHAR nntfpx[];              /* full Usenet prefix (incl. ':')       */
extern CHAR locfpx[];              /* full local news prefix (incl. ':')   */
extern CHAR nntobd[];              /* NNTP outbound work directory         */
extern HMCVFILE nntmb;             /* file pointer to GALNNTP.MCV          */
extern HMCVFILE nntdmb;            /* .MCV file pointer for GALSMPTD.MSG   */
extern GBOOL nntpImporting;        /* NNTP is importing a message          */

GBOOL uuencode(FILE *inf,FILE *outf);
VOID cvtFrom(CHAR *dst,const CHAR *src);
GBOOL curHost(const CHAR *name);
GBOOL nntval(const CHAR *addr);
VOID add2db(const struct message *msg,const CHAR *idstr);
const CHAR *getref(const struct message *msg);
INT nntsnd(const CHAR *to,const struct message *msg,const CHAR *text,
           const CHAR *filatt);

GBOOL                              /*   returns TRUE to halt processing    */
hookHandleExp(                     /* handle exported message              */
INT * pRet,                        /*   GME status code                    */
struct message * pMsg,             /*   header of message to send off      */
CHAR const ** pTo,                 /*   to field                           */
CHAR const ** pAtt,                /*   path+file name of attachment       */
CHAR ** pText,                     /*   message text buffer                */
size_t TextBufSize);               /*   current text buffer size           */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __NNTP_H
