/***************************************************************************
 *                                                                         *
 *   QRYSTG.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   World-Wide Web Query-String handling utilities.                       *
 *                                                                         *
 *   Ref HTML Sourebook, 1995, Ian S. Graham, pages 162-165, 225-227.      *
 *   Ref also RFC 1866, section 8.2.1, for the definition of MIME type:    *
 *        application/x-www-form-urlencoded                                *
 *                                                                         *
 *                                              - R. Stein  7/12/95        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "qrystg.h"

#define FILREV "$Revision: 7 $"

GBOOL                              /*   return TRUE if got first           */
qrs1st(                            /* initialize parsing a query string    */
struct qrsinf *qip,                /*   ptr to query-string info block     */
CHAR *qstring)                     /*   query string (after '?' in uri for */
                                   /*   GET method, body for POST method)  */
                                   /*   (query string modified in place)   */
                                   /* Caller should not wait before calling*/
                                   /* qrsnxt() to exhaustion, as strtok()  */
{                                  /* may be used internally.              */
     CHAR *pair;
     CHAR *eqpos;

     if ((pair=strtok(qstring,"&")) == NULL) {
          return(FALSE);
     }
     strrpl(qip->name=pair,'+',' ');
     if ((eqpos=strchr(pair,'=')) == NULL) {
          decurl(pair);
          qip->value="";
          return(TRUE);
     }
     *eqpos++='\0';
     decurl(pair);
     decurl(qip->value=eqpos);
     return(TRUE);
}

GBOOL                              /*   return TRUE if got more            */
qrsnxt(                            /* next name/value pair fm query string */
struct qrsinf *qip)                /*   ptr to query-string info block     */
{
     return(qrs1st(qip,NULL));
}

CHAR *                             /*   returns same value as passed       */
decurl(                            /* decode URL escape coding             */
CHAR *url)                         /*   URL string, converted in place     */
                                   /*   (string never expands, may shrink) */

{
     CHAR *ppos;
     INT eschar;

     for (ppos=strchr(url,'%') ; ppos != NULL ; ppos=strchr(ppos,'%')) {
          if (isxdigit(ppos[1])
           && isxdigit(ppos[2])
           && sscanf(ppos+1,"%2x",&eschar) == 1) {
               *ppos++=(char)eschar;
               strcpy(ppos,ppos+2);
          }
          else {
               ppos++;   /* illegal use of percent.  left untranslated.    */
          }
     }
     return(url);
}

