/***************************************************************************
 *                                                                         *
 *   MIMECTYP.C                                                            *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   MIME Content-Type field for different file types                      *
 *                                                                         *
 *                                        - Ilya Minkin 11/14/95           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "mimectyp.h"

#define FILREV "$Revision: 8 $"

struct contype {                   /* content type translate table         */
     CHAR *type;                   /*   type (e.g. 'text/html')            */
     CHAR *ext;                    /*   file extension (e.g. 'htm')        */
     struct contype *next;         /*   link to next entry in table        */
} *contyp=NULL;                    /* head of linked list                  */

static CHAR dfltctyp[]="application/octet-stream";
static CHAR dftfilnam[]="galmctyp.txt";
static GBOOL loaded=FALSE;

VOID
lmimctyp(                          /* Reads in the type and extentions     */
                                   /*   for the Content-Type field         */
const CHAR *filnam)                /*   name of file to read from          */
{
     struct contype *curr;
     FILE *cntfil;
     CHAR *type,*ext;
     CHAR rbuf[512];
     UINT linnum;

     loaded=TRUE;
     if (contyp == NULL) {
          if ((cntfil=fopen(filnam,FOPRA)) == NULL) {
               catastro("lmimctyp: Cannot open Content-Type file %s",filnam);
          }
          linnum=0;
          while (fgets(rbuf,512,cntfil) != NULL) {
               linnum++;
               if (rbuf[0] != '#' && !isspace(rbuf[0])) {
                    if ((type=strtok(rbuf," ,\t\r\n")) == NULL
                      || (ext=strtok(NULL," ,\t\r\n")) == NULL) {
                         catastro(
                          "MIME Content-Type file %s line %u:  bad syntax",
                          filnam,linnum);
                    }
                    if (!sameas(gmimctyp(ext),dfltctyp)) {
                         catastro("MIME Content-Type file %s line %u:\n"
                                  "extension \"%s\" defined twice",
                                  filnam,linnum,ext);
                    }
                    curr=(struct contype *)alcmem(sizeof(struct contype));
                    curr->type=(CHAR *)alcmem(strlen(type)+1);
                    curr->ext=(CHAR *)alcmem(strlen(ext)+1);
                    strcpy(curr->type,type);
                    strcpy(curr->ext,ext);
                    curr->next=contyp;
                    contyp=curr;
               }
          }
          fclose(cntfil);
     }
}

const CHAR *                       /*   returns Content-Type               */
gmimctyp(                          /* get Content-Type from global list    */
const CHAR *ext)                   /*   extension to search for in list    */
{
     struct contype *curr;

     if (ext == NULL) {
          return(dfltctyp);
     }
     if (!loaded) {
          lmimctyp(dftfilnam);
     }
     for (curr=contyp ; curr != NULL ; curr=curr->next) {
          if (sameas(curr->ext,ext)) {
               return(curr->type);
          }
     }
     return(dfltctyp);
}
