/***************************************************************************
 *                                                                         *
 *   IRC.H                                                                 *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Internet Relay Chat client for Worldgroup.                            *
 *                                                                         *
 *                                        - Craig Yap 7/5/95               *
 *                                                                         *
 ***************************************************************************/

#ifndef __IRC_H
#define __IRC_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/*
   Commands that are always called to help reduce code:

   clrprf() -  Called before and after every function search
   outprf() -  Called after every function search
   rstmbk() -  Called after every function search
   setmbk() -  Called before every function search

   eventhough outprf() is called after every function search, you should
   outprf() after prfmsg's which could be very large.
*/
                                   /* IRC substates                        */
#define ENTRNCE                0   /*   entrance substate                  */
#define IRCEXIT               -1   /*   exit substate                      */
#define IRCSTART              -2   /*   ready to start IRC session         */
#define CONNECTD              -3   /*   connected to server substate       */

#define IRCVCT                -1   /* IRC session is vacant and available  */
#define IRCMDSIZ              10   /* maximum size of outgoing IRC command */
#define NICKLEN               10   /* maximum size of IRC nickname         */
#define HLPSIZ                50   /* maximum size of short help message   */
#define IRCNAMELEN            51   /* maximum size of user description     */
#define CHNSIZ                64   /* maximum size of channel name         */
#define SERVLEN              128   /* maximum length of server name        */
#define MAXRPLY              550   /* maximum reply number from server     */
#define IRCSIZ              2048   /* maximum size of user output buffer   */
#define MAXBYT              4096   /* maximum size of user input buffer    */

                                   /* incoming reply/error numeric codes   */
#define NORPLY                 0   /*   no numeric command coming          */
#define RPL_AWAY             301   /*   user is away message               */
#define RPL_WHOISUSER        311   /*   user information reply to WHOIS    */
#define RPL_WHOISSERVER      312   /*   server info reply to WHOIS         */
#define RPL_WHOISOPERATOR    313   /*   IRC operator reply to WHOIS        */
#define RPL_ENDOFWHO         315   /*   end of WHO reply                   */
#define RPL_WHOISIDLE        317   /*   idle time  - reply to WHOIS        */
#define RPL_ENDOFWHOIS       318   /*   end of WHOIS command reply         */
#define RPL_WHOISCHANNELS    319   /*   channel list reply to WHOIS        */
#define RPL_LISTSTART        321   /*   start of list output (header)      */
#define RPL_LIST             322   /*   reply to list command              */
#define RPL_LISTEND          323   /*   end of list output                 */
#define RPL_TOPIC            332   /*   TOPIC reply                        */
#define RPL_INVITING         341   /*   inviting a user to a channel       */
#define RPL_WHOREPLY         352   /*   WHO reply                          */
#define RPL_NAMREPLY         353   /*   NAMES reply                        */
#define RPL_ENDOFNAMES       366   /*   end of NAMES reply                 */
#define RPL_ENDOFMOTD        376   /*   end of message of the day          */
#define ERR_NOMOTD           422   /*   message of the day missing         */
#define ERR_NICKNAMEINUSE    433   /*   nickname is already in use         */

extern VOID ircinitcmd(VOID);      /* initializes the commands             */
extern VOID (*numrply[MAXRPLY])(   /* array of pointers to functions that  */
                                   /*   are used for numeric replies from  */
                                   /*   the server                         */
CHAR *,                            /*   nick!userid@host                   */
CHAR *,                            /*   numeric reply as a string          */
CHAR *);                           /*   rest of line after the num. reply  */

extern struct module ircmodule;    /* module interface block               */
extern HMCVFILE ircmb;             /* message block file pointer           */
extern CHAR dftserv[SERVLEN];      /* default IRC server                   */
extern SHORT dftport;              /* default port number for dftserv      */
extern CHAR *superusr;             /* key to change defaults               */
extern CHAR *irckey;               /* key required for IRC access          */
extern struct olnkcmd *ocmdhead;   /* head of list for outgoing commands   */
extern struct ilnkcmd *irplhead;   /* head of list for incoming replies    */
extern CHAR **banlst;              /* list of "banned" channels            */
extern INT nbanned;                /* number of "banned" channels          */
extern INT ircchg;                 /* IRC credit charge per minute         */

extern struct ircusr {             /* IRC user structure                   */
     INT chan;                     /*   IRC user's channel number          */
     CHAR nick[NICKLEN];           /*   user nickname                      */
     CHAR alias[NICKLEN];          /*   user internet alias                */
     CHAR serv[SERVLEN];           /*   server user is on                  */
     CHAR ircnam[IRCNAMELEN];      /*   personal description               */
     CHAR curchan[CHNSIZ];         /*   current channel user is on         */
     CHAR obuf[IRCSIZ];            /*   user output buffer                 */
     CHAR ibuf[MAXBYT];            /*   user input buffer                  */
     INT rcvwin;                   /*   currently advertised rcv window    */
     UINT rcvcnt;                  /*   current position in input buffer   */
     UINT bufcnt;                  /*   current position in output buffer  */
     SHORT port;                   /*   remote port on server              */
     INT psubstt;                  /*   internal IRC substate              */
     INT sockt;                    /*   file descriptor for connection     */
     LONG lstinp;                  /*   last time of activity              */
     CHAR flags;                   /*   user flags                         */
     struct dns dns;               /*   DNS structure                      */
     USHORT crdtim;                /*   last time credits were deducted    */
} *ircptr;
                                   /* ircusr flag defintions               */
#define IRCACTIVE   0x01           /*   IRC connection active              */

struct savirc {                    /* user IRC info                        */
     CHAR userid[UIDSIZ];          /*   User-ID (search key)               */
     CHAR modnam[MNMSIZ];          /*   Module Name (search key)           */
     CHAR nick[NICKLEN];           /*   user preferred nickname            */
     CHAR server[SERVLEN];         /*   user preferred server              */
     CHAR ircnam[IRCNAMELEN];      /*   user preferred IRCNAME             */
     SHORT port;                   /*   user preferred port on server      */
};

struct ocmdstrt {                  /* outgoing command structure           */
     CHAR cmdname[IRCMDSIZ];       /*   command to match against           */
     CHAR shrthlp[HLPSIZ];         /*   short description of command       */
     CHAR key[KEYSIZ];             /*   key required to use command        */
     VOID (*cmdfunc)(              /*   function if command matches        */
          CHAR *,                  /*   remainder of input after cmd char  */
          struct ocmdstrt *);      /*   pass back entire structure         */
     VOID (*cmdhelp)(VOID);        /*   help function to call if requested */
};

struct irplstrt {                  /* incoming reply structure from server */
     CHAR rplname[IRCMDSIZ];       /*   reply name                         */
     VOID (*rplfunc)(              /*   function if same name from server  */
          CHAR *,                  /*   who originated this output         */
                                   /*       e.g. Trillian!hrose@cs.bu.edu  */
          CHAR *,                  /*   exact reply word from server       */
          CHAR *);                 /*   remainer of line after reply word  */
};

struct olnkcmd {                   /* node for outgoing commands           */
     struct ocmdstrt comstruct;    /*   outgoing command structure         */
     struct olnkcmd *next;         /*   pointer to next node               */
};

struct ilnkcmd {                   /* node for incoming replies            */
     struct irplstrt comstruct;    /*   incoming reply structure           */
     struct ilnkcmd *next;         /*   pointer to next node               */
};

VOID regoircmd(struct ocmdstrt *);
VOID regiircmd(struct irplstrt *,INT);
VOID onping(CHAR *);
VOID ircsbf(CHAR *,SHORT);
VOID ircsnd(VOID);
VOID ircbk(struct dns *);
VOID ssavirc(struct savirc *sirc);
GBOOL ircoff(INT unum);
struct ircusr *ircavl(VOID);
VOID init_ircagt(VOID);
VOID ircdyna(CHAR *ircsfx,CHAR *parm1,CHAR *parm2,CHAR *parm3,CHAR *parm4);
VOID pfordy(INT msg,CHAR *dyna,CHAR *parm1,CHAR *parm2,CHAR *parm3,CHAR *parm4);
VOID pfor2w(INT msg,CHAR *dyna,CHAR *parm1,CHAR *parm2,CHAR *parm3,CHAR *parm4);
VOID condis(VOID);
VOID ifcs2w(VOID);
GBOOL ircdcrd(struct ircusr *);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __IRC_H
