/***************************************************************************
 *                                                                         *
 *   IDENTD.H                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 GALACTICOMM, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is the header file for the Identification Protocol for World-    *
 *   group, as outlined by RFC-1413.                                       *
 *                                                                         *
 *                                           - C. Dunn 12/19/95            *
 *                                                                         *
 ***************************************************************************/

#ifndef __IDENTD_H
#define __IDENTD_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define IDPORT 113                 /* TCP port for ident server            */
#define IDNAME "Ident"             /* name of ident server                 */
#define IDBACK 5                   /* listen() backlog                     */

struct idnusr {                    /* ident server channel information     */
     USHORT srvprt;                /*   server port (rec'd from client)    */
     USHORT cliprt;                /*   client port (rec'd from client)    */
     INT curskt;                   /*   current socket for port lookup     */
     CHAR alias[UIDSIZ];           /*   alias for verification response    */
     USHORT sttime;                /*   activity timer                     */
};

#define idnptr ((struct idnusr *)vdaptr)

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __IDENTD_H
