/***************************************************************************
 *                                                                         *
 *   FTP.H                                                                 *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Transfer Protocol client.                                        *
 *                                                                         *
 *                                              - R. Stein  7/20/94        *
 *                                                                         *
 ***************************************************************************/

#ifndef __FTP_H
#define __FTP_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define FTPCPRT 21                 /* TCP/IP port for FTP server commands  */
#define FTPDPRT 20                 /* TCP/IP port for FTP server data      */
#define FTPRSIZ 2048               /* max bytes for reply lines from server*/
#define FTPCSIZ 256                /* max bytes for command lines to server*/
#define FTPPSIZ 128                /* bytes for command parameter (eg DIR) */
#define FTPSSIZ 2048               /* file send (put) buffer size          */
#define FTPSUB "galftp"            /* FTP subdirectory of chan-spec dir    */
#define FNAMSIZ (8+1+3+1)          /* size of "FILENAME.EXT" + NUL         */

struct ftpusr {
     struct tnoscb tnoscb;         /* TNO session control block (TNO.H)    */
     struct in_addr inaddr;        /* address of server (netw byte order)  */
     INT socket;                   /* socket for command stream to server  */
     INT port;                     /* server's port (network order)        */
     INT lsnsok;                   /* socket for listening for data conn   */
     INT datsok;                   /* socket for data stream to server     */
     INT datprt;                   /* local client's port (netw order)     */
     CHAR cmdpar[FTPPSIZ];         /* command parameters (NUL-terminated)  */
     USHORT sttime;                /* 16Hz timing of connect()             */
     struct dns dns;               /* DNS resolution information           */
     CHAR cmdlin[FTPCSIZ];         /* buffer for command line to server    */
     UINT cmdcnt;                  /* count of bytes to send to server     */
     CHAR rpllin[FTPRSIZ];         /* buffer for reply line from server    */
     UINT rplcnt;                  /* count of bytes received from server  */
     INT hlpctr;                   /* help counter, 0..NCMDS-1             */
     INT flags;                    /* see FCFXXX below                     */
     FILE *fp;                     /* file being got or put                */
     CHAR lclnam[FNAMSIZ];         /* local name of file being gotten      */
     LONG room;                    /* space in channel directory           */
     LONG nbytes;                  /* bytes in current file                */
     CHAR sndbuf[FTPSSIZ];         /* buffer:  put, mget NLST, upld errmsg */
     UINT sbfcnt;                  /* number of bytes in sndbuf[]          */
     INT lnkstt;                   /* used by ascprep(), datrcv(), lclfok()*/
     ULONG tckonl;                 /* lngtck when connected                */
     ULONG byttfc;                 /* bytes traffic (either direction)     */
     INT errmsg;                   /* error message number (upload abort)  */
     INT errnum;                   /* error number (from stack)            */
     INT drcwin;                   /* data conn recv window (as advertised)*/
     INT lstoba;                   /* for timing out NQC prompt (eg DIR)   */
     LONG rbytes;                  /* bytes reported for current file      */
};

#define ftpptr ((struct ftpusr *)vdaptr) /* FTP client info, current user  */
#define ftpupt(unum) ((struct ftpusr *)vdaoff(unum)) /* info for any user  */

/*--- ftpptr->flags masks (reset with each new host) ---*/
#define FCFXFR 0x0001              /* transfer in progress                 */
#define FCFUGT 0x0002              /* successful upload occurred           */
#define FCFIMG 0x0004              /* binary image mode                    */
#define FCFTRV 0x0008              /* trivial, show reply only if verbose  */
#define FCFCYC 0x0010              /* CYCLE status in the status queue     */
#define FCFUIP 0x0020              /* upload in progress                   */
#define FCFUAB 0x0040              /* file upload aborted by control conn  */
#define FCFCMD 0x0080              /* listening for commands               */

/*--- tnoscb->flags masks ---*/
#define FTPSSG 0x0001              /* 1=server in SGA (in case needs ack)  */
#define FTPCSG 0x0002              /* 1=client in SGA (rare, but must ack) */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __FTP_H
