/***************************************************************************
 *                                                                         *
 *   FORMFILE.C                                                            *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  Freeware source code.      *
 *                                                                         *
 *   Please feel free to use this source code as a baseline to create      *
 *   your own World-Wide Web Forms-handling add-on product, for use        *
 *   with a Worldgroup server and the Internet Connectivity Option.        *
 *                                                                         *
 *   Forms-to-file recorder.                                               *
 *                                                                         *
 *                                              - R. Stein  7/12/95        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "tcpip.h"
#include "webd.h"
#include "qrystg.h"
#include "galfrmfl.h"
#if defined(UNIX)
#include <fcntl.h>
#include <unistd.h>
#define ALLFILES "*"
#else
#define ALLFILES "*.*"
#endif

#define FILREV "$Revision: 9 $"

static VOID fflwebreq(CHAR *uri);
static CHAR *fflpth(CHAR *filnam);

static HMCVFILE fflmb;
static VOID (*oldwebreq)(          /* Web request vector                   */
     CHAR *uri);                   /*   URI following method in req line   */
static CHAR *fflpfix;
static CHAR *fflroot;
static LONG fflmax;

#define SPRSIZ 120                 /* max assumed size of spr() buffer     */

void EXPORT
init__galfrmfl(void)
{
     init__webd();
     fflmb=opnmsg("galfrmfl.mcv");
     if (samend(fflroot=stgopt(FFLROOT),"\\")
      || samend(fflroot,"/")) {
          fflroot[strlen(fflroot)-1]='\0';
     }                             /* strip '\' (if any) off end of FFLROOT*/
     gmkdir(fflroot);
     fflpfix=getmsg(FFLPFIX);
     if (*fflpfix != '/') {
          movmem(fflpfix,fflpfix+1,strlen(fflpfix)+1);
          *fflpfix='/';
     }
     if (!samend(fflpfix,"/")) {
          strcat(fflpfix,"/");
     }
     fflpfix=strdup(fflpfix);      /* FFLPFIX gets '/' on both ends        */
     fflmax=lngopt(FFLMAX,0,2147483647L);
     oldwebreq=hdlwebreq;
     hdlwebreq=fflwebreq;
}

VOID EXPORT
initwc__galfrmfl(VOID)
{
     init__galfrmfl();
}

static VOID
fflwebreq(                         /* form-to-file (*hdlwebreq)() vector   */
CHAR *uri)                         /*   URI from request line              */
{
     CHAR *ffluri;
     FILE *fp;
     CHAR *qpos;
     struct qrsinf qsinf;
     CHAR *ascmsg;
     GBOOL more;
     CHAR *pth;

     if (!sameto(fflpfix,uri)) {
          (*oldwebreq)(uri);
          return;
     }
     setmbk(fflmb);
     if (!sameas(webdptr->method,"GET")) {
          byeweb(NOMETH,webdptr->method);
          return;
     }
     ffluri=uri+strlen(fflpfix)-1;      /* ffluri should start with a '/'  */
     if ((qpos=strchr(ffluri,'?')) == NULL) {
          byeweb(BADFMT,fflpfix);
          return;
     }
     *qpos++='\0';
     cntdir(fflpth(ALLFILES));
     if (numbytp+strlen(qpos) >= fflmax) {   /* (imperfect, but close enuf)*/
          byeweb(TOOBIG);
          return;
     }
     if (badfspec(ffluri)) {
          return;
     }
     pth=fflpth(ffluri);
     if ((fp=fopen(pth,FOPAB)) == NULL) {
          byeweb(CANTOPEN);
          return;
     }
     fprintf(fp,cr2lf(xlttxv(stpans(getasc(FILHDR)),mxmssz)),
             webdptr->refer == NULL ? "" : webdptr->refer);
     ascmsg=cr2lf(xlttxv(stpans(getasc(FILLIN)),mxmssz));
     for (more=qrs1st(&qsinf,qpos) ; more ; more=qrsnxt(&qsinf)) {
          fprintf(fp,ascmsg,qsinf.name,cr2lf(qsinf.value));
     }
     fprintf(fp,cr2lf(xlttxv(stpans(getasc(FILFTR)),mxmssz)));
     fclose(fp);
     byeweb(FILEDOK);
}

static CHAR *
fflpth(                            /* format path name of forms-to-file fil*/
CHAR *filnam)                      /* page name (can start with "/" or "\")*/
{                                  /* returns "" if combination too long   */
     if (strlen(fflroot)+1+strlen(filnam)+1 > SPRSIZ) {
          return("");
     }
     #ifdef UNIX
          return(spr(filnam[0] == '/' ? "%s%s" : "%s/%s",fflroot,filnam));
     #else
          return(spr(filnam[0] == '\\'
                  || filnam[0] == '/' ? "%s%s" : "%s/%s",fflroot,filnam));
     #endif
}

