/***************************************************************************
 *                                                                         *
 *   PARMURL.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML URL encoded parameter container class declarations.       *
 *                                                                         *
 *                                           - J. Alvrus    06/19/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMURL_H
#define __PARMURL_H

#include "gcomm.h"
#include "acthutl.h"
#include "parmbase.h"

class acthParamURL : public acthParam { // URL encoded parameter

public:

     acthParamURL(                 // constructor
     CHAR const * _name,           //   name of parameter (decoded)
     CharIStreamIt const * _valbeg, //  beginning of value
     CharIStreamIt const * _valend, //  past end of value
     CharIStreamIt const * _partbeg) : // beginning of part
          acthParam(_name,_valbeg,_valend,_partbeg)
     {
     }

     acthParamURL();               // default constructor (never to be used)

     virtual
     INT                           //   returns EOF when done
     getChar(                      // get next (decoded) character from param
     CharIStreamIt * pit) const;   //   based on this iterator

     virtual
     INT
     numHeaders() const;           // get number of parameter headers

     virtual
     size_t                        //   returns length of value (less term.)
     getHeader(                    // get a parameter header
     INT index,                    //   by index
     CHAR * namBuf,                //   buffer to receive name
     size_t namSiz,                //   size of name buffer
     CHAR * valBuf,                //   buffer to receive value
     size_t valSiz) const;         //   size of value buffer

     virtual
     bool                          //   returns true if header exists
     getHeader(                    // get a parameter header
     CHAR const * name,            //   by name
     CHAR * valBuf,                //   buffer to receive result
     size_t valSiz) const;         //   size of buffer

};

#endif // __PARMURL_H
