/***************************************************************************
 *                                                                         *
 *   PARMURL.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML URL encoded parameter container class implementation.     *
 *                                                                         *
 *                                           - J. Alvrus    06/19/1998     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "parmurl.h"

#define FILREV "$Revision: 1 $"

MARKSOURCE(parmurl)

acthParamURL::acthParamURL()       // default constructor (never to be used)
{                                  // (but STL wants it for some reason)
     ASSERTM(0,"acthParamURL() default constructor called!");
}

INT                                //   returns EOF when done
acthParamURL::getChar(             // get next (decoded) character from param
CharIStreamIt * pit) const         //   based on this iterator
{
     return(::urlDecodeChar(pit,valend));
}

INT
acthParamURL::numHeaders() const   // get number of parameter headers
{
     return(0);
}

size_t                             //   returns length of value (less term.)
acthParamURL::getHeader(           // get a parameter header
INT index,                         //   by index
CHAR * namBuf,                     //   buffer to receive name
size_t namSiz,                     //   size of name buffer
CHAR * valBuf,                     //   buffer to receive result
size_t valSiz) const               //   size of buffer
{
     (VOID)index;
     (VOID)namBuf;
     (VOID)namSiz;
     (VOID)valBuf;
     (VOID)valSiz;
     ASSERTM(FALSE,"Invalid call to getHeader for URL encoded parameter");
     return(0);
}

bool                               //   returns true if header exists
acthParamURL::getHeader(           // get a parameter header
CHAR const * name,                 //   by name
CHAR * valBuf,                     //   buffer to receive result
size_t valSiz) const               //   size of buffer
{
     (VOID)name;
     (VOID)valBuf;
     (VOID)valSiz;
     return(false);
}
