/***************************************************************************
 *                                                                         *
 *   PARMMLT.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML multipart parameter container class declarations.         *
 *                                                                         *
 *                                           - J. Alvrus    06/19/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMMLT_H
#define __PARMMLT_H

#include "gcomm.h"
#include "acthutl.h"
#include "parmbase.h"

struct HDRPOS {
     HDRPOS() {}
     HDRPOS(
     CharIStreamIt const & initBeg,
     CharIStreamIt const & initEnd) :
          beg(initBeg),
          end(initEnd)
     {
     }
     HDRPOS(
     HDRPOS const & old) :
          beg(old.beg),
          end(old.end)
     {
     }
     CharIStreamIt beg;
     CharIStreamIt end;
};

class acthParamMulti : public acthParam { // URL encoded parameter

public:

     acthParamMulti(               // constructor
     CHAR const * _name,           //   name of parameter (decoded)
     CharIStreamIt const * _valbeg, //  beginning of value
     CharIStreamIt const * _valend, //  past end of value
     CharIStreamIt const * _partbeg); // beginning of part

     acthParamMulti();             // default constructor (never to be used)

     INT                           //   returns EOF when done
     getChar(                      // get next (decoded) character from param
     CharIStreamIt * pit) const;   //   based on this iterator

     INT
     numHeaders() const;           // get number of parameter headers

     size_t                        //   returns length of value (less term.)
     getHeader(                    // get a parameter header
     INT index,                    //   by index
     CHAR * namBuf,                //   buffer to receive name
     size_t namSiz,                //   size of name buffer
     CHAR * valBuf,                //   buffer to receive value
     size_t valSiz) const;         //   size of value buffer

     bool                          //   returns true if header exists
     getHeader(                    // get a parameter header
     CHAR const * name,            //   by name
     CHAR * valBuf,                //   buffer to receive result
     size_t valSiz) const;         //   size of buffer

private:                           // private member functions

     size_t                        //   returns length of value (less term.)
     ExtractHeader(                // extract header contents into buffer
     CharIStreamIt const & valBeg, //   beginning of value
     CharIStreamIt const & valEnd, //   past end of value
     CHAR * valBuf,                //   buffer to receive value
     size_t valSiz) const;         //   size of buffer

private:                           // private data members
     std::vector<HDRPOS> m_hdrVec; // vector of headers
};

#endif // __PARMMLT_H
