/***************************************************************************
 *                                                                         *
 *   PARMBASE.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML base parameter container class declarations.              *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMBASE_H
#define __PARMBASE_H

#include "gcomm.h"
#include "acthutl.h"

extern const INT EXPORT pnamesiz;  // max room for parameter name (decoded)

class acthParam {                  // parameter value reference

public:

     acthParam(                    // constructor
     CHAR const * _name,           //   name of parameter (decoded)
     CharIStreamIt const * _valbeg, // beginning of value
     CharIStreamIt const * _valend, // past end of value
     CharIStreamIt const * _partbeg); // beginning of part

     acthParam(                    // copy constructor
     acthParam const &);

     acthParam&
     operator=(                    // assignment operator
     acthParam const &);

     acthParam();                  // default constructor (never to be used)

     virtual
     ~acthParam();                 // destructor

     bool
     operator==(                   // acthParm == CHAR *
     CHAR const * nam) const;

     friend bool
     operator==(                   // CHAR * == acthParam
     CHAR * const nam,
     acthParam const & prm);

     virtual
     ULONG
     sizVal() const;               // room needed to decode & terminate value

     size_t                        //   returns # chars put in towhere
     getVal(                       // get and decode parameter value
     CHAR * towhere,               //   where to put string ('\0' terminated)
     size_t maxbytes) const;       //   max writeable at towhere (incl term)

     CHAR const *
     getName() const;              // get decoded name of parameter

     CharIStreamIt
     getValBegIt() const;          // get an iterator to start of value

     CharIStreamIt
     getValEndIt() const;          // get an iterator to end of value

     CharIStreamIt
     getPartBegIt() const;         // get an iterator to start of part

     virtual
     INT                           //   returns EOF when done
     getChar(                      // get next (decoded) character from param
     CharIStreamIt * pit) const=0; //   based on this iterator

     virtual
     INT
     numHeaders() const=0;         // get number of parameter headers

     virtual
     size_t                        //   returns length of value (less term.)
     getHeader(                    // get a parameter header
     INT index,                    //   by index
     CHAR * namBuf,                //   buffer to receive name
     size_t namSiz,                //   size of name buffer
     CHAR * valBuf,                //   buffer to receive value
     size_t valSiz) const=0;       //   size of buffer

     virtual
     bool                          //   returns true if header exists
     getHeader(                    // get a parameter header
     CHAR const * name,            //   by name
     CHAR * valBuf,                //   buffer to receive result
     size_t valSiz) const=0;       //   size of buffer

protected:                         // protected data members
     CHAR * name;                  //   name of parameter (own copy)
     CharIStreamIt valbeg;         //   istream iterator, value start
     CharIStreamIt valend;         //   istream iterator, value end
     CharIStreamIt partbeg;        //   istream iterator, part start
};

#endif // __PARMBASE_H
