/***************************************************************************
 *                                                                         *
 *   PARMBASE.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML base parameter container class implementation.            *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#include "parmbase.h"
#include "galacth.h"

#define FILREV "$Revision: 1 $"

const INT pnamesiz=PNAMESIZ;       // max room for parameter name (decoded)

MARKSOURCE(parmbase)

acthParam::acthParam(              // constructor
CHAR const * _name,                //   name of parameter (decoded)
CharIStreamIt const * _valbeg,     //   beginning of value
CharIStreamIt const * _valend,     //   past end of value
CharIStreamIt const * _partbeg) :  //   beginning of part
     valbeg(*_valbeg),
     valend(*_valend),
     partbeg(*_partbeg)
{
     name=strcpy(new CHAR[strlen(_name)+1],_name);
}

acthParam::acthParam(              // copy constructor
const acthParam& oth) :
     valbeg(oth.valbeg),
     valend(oth.valend),
     partbeg(oth.partbeg)
{
     name=strcpy(new CHAR[strlen(oth.name)+1],oth.name);
}

acthParam&
acthParam::operator=(              // assignment operator
const acthParam& oth)
{
     valbeg=oth.valbeg;
     valend=oth.valend;
     partbeg=oth.partbeg;
     if (name != NULL) {
          delete[] name;
     }
     name=strcpy(new CHAR[strlen(oth.name)+1],oth.name);
     return(*this);
}

bool
acthParam::operator==(             // acthParm == CHAR *
const CHAR *nam) const
{
     return(sameas(name,nam));
}

bool
operator==(                        // CHAR * == acthParam
const CHAR *nam,
const acthParam& prm)
{
     return(prm == nam);
}

acthParam::acthParam()             // default constructor (never to be used)
{                                  // (but STL wants it for some reason)
     ASSERTM(0,"acthParam() default constructor called!");
}

acthParam::~acthParam()            // destructor
{
     delete[] name;
}

ULONG
acthParam::sizVal() const          // room needed to decode & terminate value
{
     return((valend-valbeg)+1);
}

size_t                             //   returns length of parameter (sans term)
acthParam::getVal(                 // get and decode parameter value
CHAR * towhere,                    //   where to put string ('\0' terminated)
size_t maxbytes) const             //   max writeable at towhere (incl term)
{
     if (towhere == NULL || maxbytes == 0) {
          return(sizVal());
     }
     INT n=0;
     CharIStreamIt it=valbeg;
     INT c;
     while (n < maxbytes-1 && (c=getChar(&it)) != EOF) {
          *towhere++=c;
          ++n;
     }
     *towhere='\0';
     return(n);
}

const CHAR *
acthParam::getName() const         // get decoded name of parameter
{
     return(name);
}

CharIStreamIt
acthParam::getValBegIt() const     // get an iterator to start of value
{
     return(valbeg);
}

CharIStreamIt
acthParam::getValEndIt() const     // get an iterator to end of value
{
     return(valend);
}

CharIStreamIt
acthParam::getPartBegIt() const    // get an iterator to start of part
{
     return(partbeg);
}
