/***************************************************************************
 *                                                                         *
 *   PARMSBUF.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML parameter stream buffer class implementation.             *
 *                                                                         *
 *                                           - J. Alvrus    06/19/1998     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "parmsbuf.h"

acthParamStreamBuf::acthParamStreamBuf( // construct a stream to input a param
acthParam const & param) :         //   parameter to input
     m_pParam(&param),
     m_itIn(param.getValBegIt())
{
     setg(&m_c,(&m_c)+1,(&m_c)+1);
}

acthParamStreamBuf::~acthParamStreamBuf() // destructor
{
}

INT                                //   return EOF=fail
acthParamStreamBuf::underflow()    // get next character
{
     INT c=m_pParam->getChar(&m_itIn);
     if (c != EOF) {
          m_c=c;
          setg(&m_c,&m_c,(&m_c)+1);
     }
     return(c);
}
