/***************************************************************************
 *                                                                         *
 *   PARMSBUF.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML parameter stream buffer class declarations.               *
 *                                                                         *
 *                                           - J. Alvrus    06/19/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMSBUF_H
#define __PARMSBUF_H

#include "gcomm.h"
#include "acthutl.h"
#include "parmbase.h"

class acthParamStreamBuf : public streambuf {

public:
     acthParamStreamBuf(           // construct a stream to input a param
     acthParam const & param);     //   parameter to input

     ~acthParamStreamBuf();        // destructor

protected:

     INT                           //   return EOF=fail
     underflow();                  // get next character

private:                           // private data members
     acthParam const * m_pParam;   //   parameter we're working with
     CharIStreamIt m_itIn;         //   input iterator
     CHAR m_c;                     //   current input character
};

#endif // __PARMSBUF_H
