/***************************************************************************
 *                                                                         *
 *   PARMPURL.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML URL encoded parameter parsing class declarations.         *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMPURL_H
#define __PARMPURL_H

#include "gcomm.h"
#include "galacth.h"
#include "parmpars.h"
#include <stdcomp.h>               // Avoids linker duplicate symbol warnings
#define RWSTD_NO_BOOL              // related to vector<bool> with galact.cpp
#include <vector>
#include "iterand.h"
using namespace std;

class acthParamParseURL : public acthParamParser {

public:                            // public member functions

     acthParamParseURL(            // standard constructor
     acthRequest * req,            //   associated request object
     acthParamMgr * mgr);          //   associated manager object

     ~acthParamParseURL();         // destructor

     virtual bool
     process(VOID);                // do parsing

private:                           // private member functions

     acthParamParseURL();          // no default constructor

     acthParamParseURL(            // no copy constructor
     const acthParam&);

     VOID
     operator=(                    // no assignment operator
     const acthParamParseURL&);

private:                           // private data members
     istream * m_pstParam;         //   parameter stream
     istream_iterand<CHAR,streamoff> * m_pitBeg; // start-of-param name iterator
     istream_iterand<CHAR,streamoff> * m_pitVal; // start-of-param val iterator
     istream_iterand<CHAR,streamoff> * m_pitEnd; // end-of-param iterator
     istream_iterand<CHAR,streamoff> * m_pitEOF; // end-of-stream iterator
     enum {FINDEND,FINDVALUE} m_state; // processing state
};

#endif // __PARMPURL_H
