/***************************************************************************
 *                                                                         *
 *   PARMPMLT.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML URL encoded parameter parsing class declarations.         *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMPMLT_H
#define __PARMPMLT_H

#include "gcomm.h"
#include "galacth.h"
#include "parmpars.h"

// Maximum boundary length == 70, per RFC 2045, section 5.1.1.
#define BOUNDARYSIZE (CSTRLEN("\r\n--")+70+1)

// multipart/form-data parameter parsing class
class acthParamParseMulti : public acthParamParser {

public:                            // public member functions

     acthParamParseMulti(          // standard constructor
     acthRequest * req,            //   associated request object
     acthParamMgr * mgr);          //   associated manager object

     ~acthParamParseMulti();       // destructor

     virtual bool
     process(VOID);                // do parsing

private:                           // private member functions

     acthParamParseMulti();        // no default constructor

     acthParamParseMulti(          // no copy constructor
     const acthParamParseMulti&);

     VOID
     operator=(                    // no assignment operator
     const acthParamParseMulti&);

private:                           // private data members
     istream * m_pstParam;         //   parameter stream
     istream_iterand<CHAR,streamoff> * m_pitBeg; // start-of-section iterator
     istream_iterand<CHAR,streamoff> * m_pitVal; // start-of-value iterator
     istream_iterand<CHAR,streamoff> * m_pitEnd; // end-of-section iterator
     istream_iterand<CHAR,streamoff> * m_pitEOF; // end-of-stream iterator
     enum {                        //   parsing state codes
          SKIPPREAMBLE,            //     skipping preamble
          FINDBOUNDARY,            //     finding next boundary
          FINDBOUNDARYEND,         //     finding end of current boundary line
          FINDVALUESTART           //     finding start of section contents
     } m_state;                    //   parsing state holder
     bool m_inPreamble;            //   are we still skipping preamble?
     size_t m_boundaryLen;         //   length of boundary string
     CHAR m_boundary[BOUNDARYSIZE]; //  buffer for boundary
     CHAR m_name[PNAMESIZ];        //   buffer for parameter name
};

#endif // __PARMPMLT_H
