/***************************************************************************
 *                                                                         *
 *   PARMPARS.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML parameter container class declarations.                   *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMPARS_H
#define __PARMPARS_H

#include "gcomm.h"
#include "galacth.h"

#define PARSECHUNKSIZE 1024        // maximum characters to parse @ once

class acthParamMgr;                // forward declaration

class acthParamParser {            // parameter parsing base class

public:                            // public member functions

     acthParamParser(              // standard constructor
     acthRequest * req,            //   associated request object
     acthParamMgr * mgr) :         //   associated manager object
          m_req(req),
          m_mgr(mgr)
     {
     }

     virtual
     ~acthParamParser()            // derived classes must have destructor
     {
     }

     virtual bool
     process(VOID)=0;              // do parsing

private:                           // private member functions

     acthParamParser();            // no default constructor

     acthParamParser(              // no copy constructor
     const acthParamParser&);

     VOID
     operator=(                    // no assignment operator
     const acthParamParser&);

protected:                         // protected data members
     acthRequest * m_req;          //   associated request object
     acthParamMgr * m_mgr;         //   associated manager object
};

#endif // __PARMPARS_H
