/***************************************************************************
 *                                                                         *
 *   PARMMGR.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML parameter manager class declarations.                     *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARMMGR_H
#define __PARMMGR_H

#include "gcomm.h"
#include <stdcomp.h>               // Avoids linker duplicate symbol warnings
#define RWSTD_NO_BOOL              // related to vector<bool> with galact.cpp
#include <vector>
#include "iterand.h"
#include "cyctimer.h"
#include "galacth.h"
#include "parmbase.h"
#include "parmpars.h"
using namespace std;

#define PARSESLICE 10              // fixed time slice of 10 ms

typedef std::vector<acthParam *> PARAMVEC; // vector of parameters

class acthParamMgr {               // parameter management class

public:

     acthParamMgr(                 // standard constructor
     acthRequest * req);           //   associated request object

     acthParamMgr();               // default constructor (not used)

     ~acthParamMgr();              // destructor

     bool
     isReady(VOID);                // have parameters been fully parsed?

     VOID
     TrackStream(                  // keep ptr to param stream to delete
     istream * pstParam);          //   parameter stream, deleted when done

     VOID
     AddParam(                     // add a parameter to list
     acthParam * pParam);          //   allocated parameter to add

     PARAMENC                      //   returns encoding type code
     paramEncoding() const;        // get type of encoding used for parameters

     INT
     nparam() const;               // number of parameters

     bool                          //   true=parameter specified, false=missing
     param(                        // get parameter by name (false=no such)
     CHAR const * name,            //   name of parameter (case ignored)
     CHAR * value=NULL,            //   where to store value (eg "2")
     INT size=0) const;            //   room for value (incl '\0')

     INT                           //   returns length (not incl term)
     param(                        // get parameter by index
     INT index,                    //   0 to nparam()-1
     CHAR * name,                  //   where to put name (eg "parm")
     INT namsiz,                   //   room for name (incl '\0')
     CHAR * value,                 //   where to put value (eg "2")
     INT valsiz) const;            //   room for value (incl '\0')

     bool                          //   true=parameter specified, false=missing
     paramStreamOpen(              // get parameter input stream by name
     CHAR const * name,            //   name of parameter (case ignored)
     istream ** ppstParam) const;  //   buffer to receive stream pointer

     VOID
     paramStreamOpen(              // get parameter input stream by index
     INT index,                    //   0 to nparam()-1
     istream ** ppstParam) const;  //   buffer to receive stream pointer

     VOID
     paramStreamClose(             // finish up use of parameter stream
     istream * pstParam) const;    //   stream pointer from paramStreamOpen

     bool                          //   true=found, false=none
     paramIndex(                   // get index of parameter name
     CHAR const * name,            //   name of parameter (case ignored)
     INT & idx) const;             //   answer, 0 to nparam()-1

     INT                           //   room needed to store param (incl term)
     paramRoom(                    // room needed to decode entire param
     CHAR const * name) const;     //   name of parameter (eg "parm")

     INT                           //   room needed to store param (incl term)
     paramRoom(                    // room needed to decode entire param
     INT index) const;             //   0 to nparam()-1

     INT
     paramNumHeaders(              // get number of parameter headers
     INT index) const;             //   0 to nparam()-1

     size_t                        //   returns length of value (less term.)
     paramHeader(                  // get a parameter header
     INT index,                    //   index of parameter (0 to nparam()-1)
     INT hdrIndex,                 //   index of header
     CHAR * namBuf,                //   buffer to receive name
     size_t namSiz,                //   size of name buffer
     CHAR * valBuf=NULL,           //   buffer to receive result
     size_t valSiz=0) const;       //   size of buffer

     bool                          //   returns true if header exists
     paramHeader(                  // get a parameter header
     INT index,                    //   index of parameter (0 to nparam()-1)
     CHAR const * hdrName,         //   name of header
     CHAR * valBuf=NULL,           //   buffer to receive result
     size_t valSiz=0) const;       //   size of buffer

     INT
     paramNumHeaders(              // get number of parameter headers
     CHAR const * name) const;     //   name of parameter (eg "parm")

     bool                          //   returns true if parameter exists
     paramHeader(                  // get a parameter header
     CHAR const * name,            //   name of parameter (case ignored)
     INT hdrIndex,                 //   index of header
     CHAR * namBuf,                //   buffer to receive name
     size_t namSiz,                //   size of name buffer
     CHAR * valBuf=NULL,           //   buffer to receive result
     size_t valSiz=0) const;       //   size of buffer

     bool                          //   returns true if parameter/header exist
     paramHeader(                  // get a parameter header
     CHAR const * name,            //   name of parameter (case ignored)
     CHAR const * hdrName,         //   name of header
     CHAR * valBuf=NULL,           //   buffer to receive result
     size_t valSiz=0) const;       //   size of buffer

private:                           // private member functions

     PARAMENC
     EncType(VOID);                // determine encoding type

     CHAR const *                  //   returns content in static buffer
     ReadEncTypeHdr(VOID);         // read "Content-type" header

private:                           // private data members
     PARAMVEC m_vec;               //   vector of parameters
     acthRequest * m_req;          //   associated request object
     acthParamParser * m_parser;   //   parameter parsing object
     istream * m_pst;              //   parameter stream to delete when done
     cycleTimer m_timer;           //   parsing time slicer
     bool m_ready;                 //   parameters fully parsed flag
     PARAMENC m_enc;               //   how are parameters encoded?
};

#endif // __PARMMGR_H
