/***************************************************************************
 *                                                                         *
 *   OPT.H                                                                 *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML Kernel configuration options.  Place declarations         *
 *   related to kernel configuration here.                                 *
 *                                                                         *
 *                                           - J. Alvrus    02/01/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__OPT_H)
#define __OPT_H

#include "gcomm.h"

                                   // authentication type flags
#define ATF_BROWSER 1              //   browser ("Authorization" header)
#define ATF_COOKIE  2              //   cookie ("Cookie" header)
extern INT AuthTypeFlags;          // allowed authentication types
extern INT AuthDefault;            // default authentication type

#define MAXREALM 256               // maximum length of authentication realm
extern CHAR AuthRealm[MAXREALM];   // authentication realm

#define MAXCOOKIE 256              // maximum length of auth. cookie name
extern CHAR AuthCookie[MAXCOOKIE]; // authentication cookie name

#define MINPARMSLICE 1             // minimimum allowed value for time slice
#define MAXPARMSLICE 1000          // maximum allowed value for time slice
extern INT ParmParseSlice;         // parameter parsing time slice

#endif // __OPT_H
