/***************************************************************************
 *                                                                         *
 *   OBJDATA.H                                                             *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Template for storing and retrieving additional data for a class.      *
 *                                                                         *
 *                                           - J. Alvrus    02/01/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__OBJDATA_H)
#define __OBJDATA_H

#include <map>

#define FILREV "$Revision$"

template <class ObjectType, class DataType>
class ObjectDataHolder {

private:
     typedef std::map<ObjectType const *,DataType,less<ObjectType const *> > MapType;
     MapType m_map;

public:
     ObjectDataHolder()
     {
     }

     ~ObjectDataHolder()
     {
     }

     DataType *
     add(ObjectType const * owner) // add data for an instance
     {
          DataType data;
          pair<MapType::iterator,bool> res
               =m_map.insert(MapType::value_type(owner,data));
          ASSERT(res.second);
          return(&(*(res.first)).second);
     }

     DataType *
     get(ObjectType const * owner) // get data for an instance
     {
          return(&((*llget(owner)).second));
     }

     void
     del(ObjectType const * owner) // remove data for an instance
     {
          m_map.erase(llget(owner));
     }

private:

     MapType::iterator
     llget(ObjectType const * owner) // low-level get-item
     {
          MapType::iterator p=m_map.find(owner);
          ASSERT(p != m_map.end());
          return(p);
     }

};

#undef FILREV

#endif // __OBJDATA_H
