/***************************************************************************
 *                                                                         *
 *   ACTHUTL.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Active HTML internal utilities.                                       *
 *                                                                         *
 *                                           - J. Alvrus    06/16/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __ACTHUTL_H
#define __ACTHUTL_H

#include "gcomm.h"
#include <stdcomp.h>               // Avoids linker duplicate symbol warnings
#define RWSTD_NO_BOOL              // related to vector<bool> with galact.cpp
#include <vector>
#include "galacth.h"
#include "iterand.h"
using namespace std;

// handy typedefs

typedef istream_iterand<CHAR,streamoff> CharIStreamIt;

// standard algorithm type stuff

template <class InputIterator1, class InputIterator2>
bool
itSameTo(                          // iterator-based sameto()
InputIterator1 first1,             //   start of sub-string
InputIterator1 last1,              //   end of sub-string
InputIterator2 first2,             //   start of string to search
InputIterator2 last2)              //   end of string to search
{
     while (first1 != last1 && first2 != last2
         && toupper(*first1) == toupper(*first2)) {
          ++first1;
          ++first2;
     }
     return(first1 == last1);
}

// function declarations

CHAR const *                       //   returns ptr to value if found
FindHeader(                        // find start of header field's contents
acthRequest * req,                 //   request to read from
CHAR const * name);                //   name of field (eg "Accept")

bool                               //   returns true if found
ReadHeader(                        // read a header field's entire contents
acthRequest * req,                 //   request to read from
CHAR const * name,                 //   name of field (eg "Accept")
size_t valsiz,                     //   room for value (incl '\0')
CHAR * valbuf);                    //   where to put value (eg "*/*")

CHAR const *                       //   pointer to char after end of value
FindHeaderValueEnd(                // find end of header value (incl. quoted)
CHAR const * valStart,             //   start of value
CHAR altBreak);                    //   alternate break character (e.g. ';')

CHAR *                             //   returns pointer to destination buffer
ExtractHeaderValue(                // extract a header's values (incl. quoted)
CHAR const * pStart,               //   start of value (== '\"' if quoted)
CHAR const * pEnd,                 //   end of value ([-1] == '\"' if quoted)
size_t * pvalsiz,                  //   size of destination buffer (updated)
CHAR * valbuf);                    //   buffer to receive value

// The following function reads the first portion of a structured, semicolon-
// delimited header field.  For example, in the header field:
//
//   Content-Disposition: form-data; name="libname"
//
// The value of the "Content-Disposition" header field is "form-data".
// The "name=..." portion is an additional parameter, read using
// ReadHeaderParam().

bool                               //   returns true if found
ReadHeaderValue(                   // read a value of header field
acthRequest * req,                 //   request to read from
CHAR const * name,                 //   name of field (eg "Accept")
size_t valsiz,                     //   room for value (incl '\0')
CHAR * valbuf);                    //   where to put value (eg "*/*")

bool                               //   returns true if found
ReadHeaderParam(                   // read a parameter of header field
acthRequest * req,                 //   request to read from
CHAR const * hdrName,              //   name of header (e.g. "Content-type")
CHAR const * paramName,            //   name of parameter (e.g. "boundary")
size_t valsiz,                     //   room for value (incl '\0')
CHAR * valbuf);                    //   where to put value (e.g. "*/*")

bool                               //   returns true if found
ExtractHeaderParam(                // extract a parameter of header field
CHAR const * hdr,                  //   entire header contents
CHAR const * paramName,            //   name of parameter (e.g. "boundary")
size_t * pvalsiz,                  //   size of destination buffer (updated)
CHAR * valbuf);                    //   where to put value (e.g. "*/*")

INT                                //   returns decoded size
urlDecode(                         // decode a URL encoded parameter
CharIStreamIt ncfirst,             //   start of parameter value
CharIStreamIt nclast,              //   end of parameter value
CHAR * dcbuffer,                   //   buffer to receive result
INT dcsize);                       //   size of buffer

INT                                //   returns next char or EOF
urlDecodeChar(                     // decode next char from URL encoded stream
CharIStreamIt * pitBeg,            //   iterator to current char (updated)
CharIStreamIt const & itEnd);      //   end of stream iterator

size_t                             //   returns length of value (less term.)
StreamToBuffer(                    // extract from a stream to a buffer
CharIStreamIt const & stBeg,       //   beginning of stream data
CharIStreamIt const & stEnd,       //   past end of stream data
CHAR * buf,                        //   buffer to receive data
size_t bufSiz);                    //   size of buffer

#endif // __ACTHUTL_H
