/***************************************************************************
 *                                                                         *
 *   GALFNT.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the offline utility to edit the fax fonts.                    *
 *                                                                         *
 *                               - C. Robert and B. Stephens  12/17/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "galfax.h"

#define FILREV "$Revision: 1.3 $"

extern CHAR scntbl[][GVIDSCNSIZ];  /* array of screens (c/o MAKESCNS)      */
static CHAR dosscn[GVIDSCNSIZ],    /* saved DOS screen image               */
            savscn[GVIDSCNSIZ],    /* generic saved screen image           */
            savsc2[GVIDSCNSIZ];    /* generic saved screen image #2        */

CHAR *bigfnt,                      /* "big chars" in-memory font chars     */
     *smlfnt;                      /* "small chars" in-memory font chars   */


static VOID ldfont(VOID);
static GBOOL edtfnt(CHAR c);
static GBOOL chkabt(VOID);
static VOID svfont(VOID);
static VOID wrapup(VOID);

VOID
main(VOID)                         /* main program loop                    */
{
     INT c;
     GBOOL changed=FALSE;

TRY
     initvid();
     ldfont();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     cvtscn(scntbl[1]);
     explode(scntbl[0],0,0,79,24);
     proff(0,0);
     scn2mem(savscn,0,GVIDSCNSIZ);
     while (TRUE) {
          explode(scntbl[1],22,6,56,13);
          proff(0,0);
          locate(49,12);
          cursiz(GVIDLILCURS);
#ifdef GCWINNT
          if ((c=getchc()) == ESC) {
#endif
#ifdef GCDOS
          if ((c=getchc()) == ESC && lascan() != 0) {
#endif
               if (!changed || chkabt()) {
                    wrapup();
                    exit(0);
               }
          }
          else if (c == ALT_X) {
               svfont();
               wrapup();
               exit(0);
          }
          else if (edtfnt(c)) {
               changed=TRUE;
          }
     }
EXCEPT
}

static VOID
ldfont(VOID)                       /* load up the font arrays (big and sml)*/
{
     FILE *fp;

     bigfnt=alcmem(BFNSIZ);
     smlfnt=alcmem(SFNSIZ);
     if ((fp=fopen("GALFAX.FNT",FOPRB)) == NULL) {
          catastro("CAN'T OPEN \"GALFAX.FNT\" FOR READING!");
     }
     if (fread(bigfnt,1,BFNSIZ,fp) != BFNSIZ
      || fread(smlfnt,1,SFNSIZ,fp) != SFNSIZ) {
          catastro("BAD \"GALFAX.FNT\" FILE!");
     }
     fclose(fp);
}

static GBOOL                       /*   returns TRUE if changed            */
edtfnt(                            /* edit a font character now            */
CHAR c)                            /*   character to edit                  */
{
     CHAR chr,sarea[8],barea[16],*ptr;
     INT ch,i,j,x=0,y=0,xoff,yoff;
     GBOOL big=TRUE;

     mem2scn(savscn,0,GVIDSCNSIZ);
     movmem(&smlfnt[c*8],sarea,8);
     movmem(&bigfnt[c*16],barea,16);
     setatr(0x1A);
     for (i=0 ; i < 16 ; i++) {
          chr=barea[i];
          for (j=0 ; j < 8 ; j++) {
               locate(1+j,6+i);
               printf("%c",((chr<<j)&0x80) ? 177 : 32);
          }
     }
     for (i=0 ; i < 8 ; i++) {
          chr=sarea[i];
          for (j=0 ; j < 8 ; j++) {
               locate(29+j,11+i);
               printf("%c",((chr<<j)&0x80) ? 177 : 32);
          }
     }
     locate(xoff=1,yoff=6);
     while (TRUE) {
          if ((ch=getchc()) == ESC) {
               break;
          }
          else if (ch == 13) {
               movmem(sarea,&smlfnt[c*8],8);
               movmem(barea,&bigfnt[c*16],16);
               break;
          }
          else if (ch == 32) {
               ptr=(big ? barea : sarea);
               if (ptr[y]&(0x80>>x)) {
                    ptr[y]&=~(0x80>>x);
                    printf("%c",32);
               }
               else {
                    ptr[y]|=(0x80>>x);
                    printf("%c",177);
               }
               locate(x+xoff,y+yoff);
          }
          else if (ch == TAB) {
               big=!big;
               xoff=(big ? 1 : 29);
               yoff=(big ? 6 : 11);
               locate(xoff,yoff);
               x=y=0;
          }
          else {
               switch (ch) {
               case CRSRUP:
                    if (y > 0) {
                         locate(x+xoff,--y+yoff);
                    }
                    break;
               case CRSRDN:
                    if (y < (big ? 15 : 7)) {
                         locate(x+xoff,++y+yoff);
                    }
                    break;
               case CRSRRT:
                    if (x < 7) {
                         locate(++x+xoff,y+yoff);
                    }
                    break;
               case CRSRLF:
                    if (x > 0) {
                         locate(--x+xoff,y+yoff);
                    }
                    break;
               }
          }
     }
     scn2mem(savscn,0,GVIDSCNSIZ);
     return(ch != ESC);
}

static GBOOL
chkabt(VOID)                       /* check and make sure of abort command */
{
     GBOOL retval;
     CHAR stg[7];

     scn2mem(savsc2,0,GVIDSCNSIZ);
     explodeto(scntbl[1],13,17,64,19,13,10);
     proff(0,0);
     strcpy(stg,"No");
     retval=(edtval(60,11,4,stg,validyn,MCHOICE) && tolower(stg[0]) == 'y');
     mem2scn(savsc2,0,GVIDSCNSIZ);
     return(retval);
}

static VOID
svfont(VOID)                       /* save the font arrays (big and sml)   */
{
     FILE *fp;

     if ((fp=fopen("GALFAX.FNT",FOPWB)) == NULL) {
          catastro("CAN'T OPEN \"GALFAX.FNT\" FOR WRITING!");
     }
     fwrite(bigfnt,1,BFNSIZ,fp);
     fwrite(smlfnt,1,SFNSIZ,fp);
     fclose(fp);
}

static VOID
wrapup(VOID)                       /* wrap things up before exiting        */
{
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     clsvid();
}
