/***************************************************************************
 *                                                                         *
 *   SCN2C.C                                                               *
 *                                                                         *
 *   Copyright (c) 1989-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Convert a screen image to C for inclusion into an EXE.                *
 *                                                                         *
 *                                        - T. Stryker 7/8/89              *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 3 $"

static FILE *fp;                   /* general purpose file pointer         */

static UCHAR scnbuf[GVIDSCNSIZ];   /* screen buffer                        */

INT
main(                              /* main                                 */
INT argc,
CHAR *argv[])
{
     UCHAR *chrptr;
     USHORT line,column;

     if (argc != 3) {
          fprintf(stderr,"cmd fmt is: scn2c scnfile cfile\n");
          return(1);
     }
     if ((fp=fopen(argv[1],FOPRB)) == NULL) {
          fprintf(stderr,"can't open %s for input\n",argv[1]);
          return(1);
     }
     if (fread(scnbuf,GVIDSCNSIZ,1,fp) != 1) {
          fclose(fp);
          fprintf(stderr,"error reading %s\n",argv[1]);
          return(1);
     }
     fclose(fp);
     if ((fp=fopen(argv[2],FOPWA)) == NULL) {
          fprintf(stderr,"can't open %s for output\n",argv[2]);
          return(1);
     }
     chrptr=scnbuf;
     for (line=0 ; line < 250 ; line++) {
          for (column=0 ; column < 16 ; column++) {
               fprintf(fp,"0x%02X,",(*chrptr)&0xFF);
               chrptr+=1;
          }
          fprintf(fp,"\n");
     }
     fclose(fp);
     return(0);
}

