/***************************************************************************
 *                                                                         *
 *   GALVCDEF.C                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   Prepare a Borland .DEF file for use by Microsoft Visual C++.          *
 *                                                                         *
 *                                           - J. Alvrus    10/30/1998     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#undef printf                      /* don't want Gcomm version             */

#define FILREV "$Revision: 1 $"

#define ARGSRC      1              /* source file argument number          */
#define ARGDST      2              /* destination file argument number     */
#define REQARGC     3              /* required number of arguments         */

#define SRCFILE     (argv[ARGSRC]) /* source file spec                     */
#define DSTFILE     (argv[ARGDST]) /* destination file spec                */

#define MAXLINE     1024           /* maximum line length                  */

#define USAGE "Usage: galvcdef srcfile dstfile\n"                          \
              "\n"                                                         \
              "srcfile - source file (Borland format)\n"                   \
              "dstfile - destination file (Visual C++ format)\n"

                                   /* exit codes                           */
#define EC_ARG      1              /*   invalid arguments                  */
#define EC_DST      2              /*   unable to write to destination     */
#define EC_EOF      3              /*   unexpected end-of-file             */
#define EC_LTL      4              /*   line too long                      */
#define EC_SRC      5              /*   unable to read from source         */

CHAR const * DeleteOnExit=NULL;    /* file to delete on exit               */

INT                                /*   returns FALSE if EOF               */
readline(                          /* read a line from a file              */
CHAR * buf,                        /*   buffer to receive line             */
size_t bufSize,                    /*   size of buffer                     */
FILE * fp,                         /*   file to read from                  */
ULONG nLine);                      /*   line number we're reading          */

VOID
goaway(                            /* exit from program                    */
INT status);                       /*   status code to return to OS        */

INT
main(
INT argc,
CHAR const * argv[])
{
     FILE * ifp;                   /* input file stream                    */
     FILE * ofp;                   /* output file stream                   */
     CHAR * cp;                    /* temp ptr for stripping underscore    */
     ULONG nLines;                 /* number of lines processed            */
     CHAR buf[MAXLINE];            /* line input buffer                    */

     /* verify required number of arguments */
     if (argc != REQARGC) {
          printf(USAGE);
          return(EC_ARG);
     }

     /* open input file */
     if ((ifp=fopen(SRCFILE,FOPRA)) == NULL) {
          printf("UNABLE TO OPEN SOURCE FILE: %s\n",SRCFILE);
          return(EC_SRC);
     }

     /* open output file */
     if ((ofp=fopen(DSTFILE,FOPWA)) == NULL) {
          printf("UNABLE TO OPEN DESTINATION FILE: %s\n",DSTFILE);
          return(EC_DST);
     }

     nLines=0;
     DeleteOnExit=DSTFILE;

     /* find EXPORTS line */
     while (TRUE) {

          /* read a line */
          if (!readline(buf,MAXLINE,ifp,++nLines)) {
               printf("UNEXPECTED END-OF-FILE SEARCHING FOR EXPORTS\n");
               goaway(EC_EOF);
          }

          /* save line to destination */
          if (fputs(buf,ofp) == NULL) {
               printf("UNABLE TO WRITE TO %s\n",DSTFILE);
               goaway(EC_DST);
          }

          /* see if we've found EXPORTS */
          if (sameto("EXPORTS",buf) && isspace(buf[CSTRLEN("EXPORTS")])) {
               break;
          }
     }

     /* copy exported symbols after stripping leading underscore */
     while (readline(buf,MAXLINE,ifp,++nLines)) {

          /* remove first leading underscore (if any) */
          if (*(cp=skptwht(buf)) == '_') {
               strmove(cp,cp+1);
          }

          /* save line to destination */
          if (fputs(buf,ofp) == NULL) {
               printf("UNABLE TO WRITE TO %s\n",DSTFILE);
               goaway(EC_DST);
          }
     }

     fclose(ifp);
     fclose(ofp);
     DeleteOnExit=NULL;
     return(0);
}

INT                                /*   returns FALSE if EOF               */
readline(                          /* read a line from a file              */
CHAR * buf,                        /*   buffer to receive line             */
size_t bufSize,                    /*   size of buffer                     */
FILE * fp,                         /*   file to read from                  */
ULONG nLine)                       /*   line number we're reading          */
{
     if (fgets(buf,bufSize,fp) == NULL) {
          return(FALSE);
     }
     if (!samend(buf,"\n")) {
          printf("LINE #%lu TO LONG, MAX IS %u\n",nLine,bufSize);
          goaway(EC_LTL);
     }
     return(TRUE);
}

VOID
goaway(                            /* exit from program                    */
INT status)                        /*   status code to return to OS        */
{
     if (DeleteOnExit != NULL) {
          unlink(DeleteOnExit);
     }
     exit(status);
}
