/***************************************************************************
 *                                                                         *
 *   GALSYNC.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Utility to make sure that builds are done properly.                   *
 *   This program keeps track of your last -DEFINES for compilation        *
 *   and forces a rebuild if they change.                                  *
 *                                                                         *
 *                                            - W. Muharsky 04/17/97       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 3 $"

#define QUIETOPT    "-Q"           /*  Turns printing off                  */
/***************************************************************************
 * Variable declarations                                                   *
 ***************************************************************************/
static CHAR *stg1=NULL;            /*  First files options                 */
static CHAR *stg2=NULL;            /*  Second files options                */

static GBOOL Quiet=FALSE;          /*  Print stuff?                        */

/***************************************************************************
 * Function declarations                                                   *
 ***************************************************************************/
INT
main(VOID);                        /*  Main function                       */

static CHAR *                      /*  Pointer to options or NULL          */
ReadOptions(                       /*  Read options from file              */
CHAR *File);                       /*  File to read options from           */

static GBOOL                       /*  TRUE to delete, FALSE if matched    */
CheckStrings(                      /* Check if strings match               */
CHAR *stg1,                        /*  First string to check               */
CHAR *stg2);                       /*  Second string to check              */

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...);                              /*  Any other arguments                 */

/***************************************************************************
 * Source code                                                             *
 ***************************************************************************/
MARKSOURCE(galsync);               /*  Exported module stub                */

INT
main(VOID)                         /*  Main function                       */
{
     struct ffblk fb;
     INT ret;

     initvid();
     if (_argc == 4 || _argc == 5) {
          if (sameas(_argv[4],QUIETOPT)) {
               Quiet=TRUE;
          }
          ret=1;
          if ((stg1=ReadOptions(_argv[1])) != NULL) {
               if ((stg2=ReadOptions(_argv[2])) != NULL) {
                    ret=CheckStrings(stg1,stg2);
               }
          }
          if (ret == 1) {
               qprintf("Removing directory: %s",_argv[3]);
               if (fndfile(&fb,_argv[3],FAMDIR)) {
                    deldir(_argv[3]);
               }
               gmkdir(_argv[3]);
          }
     }
     else {
          setatr(0x0C);
          printf("Usage: GALSYNC <file1> <file2> [-Q]\n");
          printf("\r");
          printf("     -Q               Queit mode (print nothing)\n");
          printf("\r");
     }
     clsvid();
     return(0);
}

static GBOOL                       /*  TRUE to delete, FALSE if matched    */
CheckStrings(                      /* Check if strings match               */
CHAR *stg1,                        /*  First string to check               */
CHAR *stg2)                        /*  Second string to check              */
{
     INT c1;
     INT c2;
     CHAR data[500];

     qprintf("Checking strings:\nSTG1:%s\nSTG2:%s\n",stg1,stg2);
     for (c1=0; c1 < itemcnt(stg1); c1++) {
          strcpy(data,itemidx(stg1,c1));
          for (c2=0; c2 < itemcnt(stg2); c2++) {
               if (sameas(data,itemidx(stg2,c2))) {
                    break;
               }
          }
          if (c2 == itemcnt(stg2)) {
               return(TRUE);
          }
     }

     for (c2=0; c2 < itemcnt(stg2); c2++) {
          strcpy(data,itemidx(stg2,c2));
          for (c1=0; c1 < itemcnt(stg1); c1++) {
               if (sameas(data,itemidx(stg1,c1))) {
                    break;
               }
          }
          if (c1 == itemcnt(stg1)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

static CHAR *                      /*  Pointer to options or NULL          */
ReadOptions(                       /*  Read options from file              */
CHAR *File)                        /*  File to read options from           */
{
     FILE *fp;
     CHAR data[500];
     CHAR *ans;
     CHAR *wptr;
     GBOOL first=FALSE;

     if ((fp=fopen(File,FOPRA)) == NULL) {
          qprintf("Unable to open file %s!\n",File);
          return(NULL);
     }
     if (fgets(data,499,fp) == NULL) {
          qprintf("Unable to read from file %s!\n",File);
          return(NULL);
     }

     ans=alczer(strlen(data)+1);
     for (wptr=firstwd(data); *wptr != '\0'; wptr=nextwd()) {
          if (first) {
               strcat(ans,"\t");
          }
          first=TRUE;
          strcat(ans,wptr);
     }
     fclose(fp);
     return(ans);
}

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...)                               /*  Any other arguments                 */
{
     va_list args;

     if (!Quiet) {
          va_start(args,stg);
          vprintf(stg,args);
          va_end(arga);
     }
}
