/***************************************************************************
 *                                                                         *
 *   GALPROD.C                                                             *
 *                                                                         *
 *   Copyright (C) 1994-1996 GALACTICOMM, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is very much like GALTOUCH or TOUCH, but it takes wildcard       *
 *   parameters and if not supplied a date and time from the command       *
 *   line, will use the current date and time.                             *
 *                                                                         *
 *                                                - D. Rhea 06/03/96       *
 *                         Ported to version 3    - W. Muharsky 08/25/97   *
 *                                                                         *
 ***************************************************************************/
#include "gcomm.h"

#define QUIETOPT "-Q"              /*  Quiet option                        */
#define DATESIZE sizeof("MM/DD/YYYY") /*  buffer length for string date    */

/***************************************************************************
 * Variable Declarations                                                   *
 ***************************************************************************/
USHORT systim;                     /*  System Time                         */
USHORT sysdat;                     /*  System Date                         */

GBOOL Quiet=FALSE;                 /*  Remain quiet (don't print anything) */

/***************************************************************************
 * Function declarations                                                   *
 ***************************************************************************/
static GBOOL                       /*  TRUE if valid date                  */
ValidDate(                         /* Checks for digits and /'s            */
const CHAR *stgDate);              /*  String to check                     */

static GBOOL                       /*  TRUE if valid time                  */
ValidTime(                         /* Checks for digits and :'s            */
const CHAR *stgTime);              /*  String to check                     */

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...);                              /*  Any other arguments                 */

GBOOL                              /*  TRUE if argument is found           */
SearchArgs(                        /* Search through cmd line arguments    */
const CHAR *SearchFor);            /*  What to search for                  */

/***************************************************************************
 * Source code                                                             *
 ***************************************************************************/
MARKSOURCE(galprod);               /*  Source code marker                  */

INT
main(                              /* Main program loop                    */
INT argc,                          /*  Number of command line args         */
CHAR *argv[])                      /*  List of command line args           */
{
     INT i,j;
     CHAR dattim[DATESIZE];
     CHAR FullPath[GCMAXPTH];
     CHAR FilenPath[GCMAXPTH];
     CHAR saveAttr;
     struct ffblk fbptr;

     initvid();
     saveAttr=scngetc(gvscnoff(curcurx(),curcury())+1);

     Quiet=SearchArgs(QUIETOPT);

     setatr(0x0B);
     qprintf("\n");
     qprintf("GALPROD - Wild card touch utility.\n");
     qprintf("Copyright (C) 1994-1996 GALACTICOMM, Inc.  ");
     qprintf("All rights reserved.\n\n");
     if (argc < 2) {
          setatr(0x0C);
          printf("Usage: GALPROD [hh:mm:ss] [mm/dd/yyyy] file [file [...]]");
          setatr(saveAttr);
          printf("\n");
          clsvid();
          return(0);
     }
     sysdat=today();
     systim=now();
     j=0;
     for (i=1 ; i < argc ; i++) {
          if (strchr(argv[i],':') != NULL && ValidTime(argv[i])) {
               stzcpy(dattim,argv[i],DATESIZE);
               if ((systim=dctime(dattim)) == GCINVALIDDOT) {
                    catastro("Invalid time format!  Format must be HH:MM:SS.");
               }
          }
          else if (strchr(argv[i],'/') != NULL && ValidDate(argv[i])) {
               stzcpy(dattim,argv[i],DATESIZE);
               if ((sysdat=dcdate(dattim)) == GCINVALIDDOT) {
                    catastro("Invalid date format!  Format must be MM/DD/YYYY.");
               }
          }
          else if (argv[i][0] == '\0') {
               setatr(0x0C);
               qprintf("\n\nUnknown argument (Number %d). Ignored.",i);
               setatr(0x07);
               printf("\n");
          }
          else {
               fileparts(GCPART_PATH,argv[i],FullPath,GCMAXPTH);
               if (fnd1st(&fbptr,argv[i],0)) {
                    do {
                         setatr(0x09);
                         makePath(FilenPath,FullPath,fbptr.ff_name,GCMAXPTH);
                         qprintf("Proding file %d: %s",++j,FilenPath);
                         if (!setFileTm(FilenPath,systim,sysdat)) {
                              setatr(0x0C);
                              belper(900);
                              qprintf("\n\7.  Error prodding file.\n\n");
                         }
                         else {
                              setatr(0x0E);
                              qprintf(" ... OK                     \n");
                         }
                    } while (fndnxt(&fbptr));
               }
          }
     }
     setatr(0x0B);
     qprintf("\n%d files prodded. \n\nDone...",j);
     setatr(saveAttr);
     printf("\n");
     clsvid();
     return(0);
}

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...)                               /*  Any other arguments                 */
{
     CHAR Buffer[1000];
     va_list args;

     if (!Quiet) {
          va_start(args,stg);
          vsprintf(Buffer,stg,args);
          va_end(args);
          printf(Buffer);
     }
}

GBOOL                              /*  TRUE if argument is found           */
SearchArgs(                        /* Search through cmd line arguments    */
const CHAR *SearchFor)             /*  What to search for                  */
{
     UINT count;

     for (count=0; count < _argc; count++) {
          if (sameas(SearchFor,_argv[count])) {
               return(TRUE);
          }
     }
     return(FALSE);
}

static GBOOL                       /*  TRUE if valid date                  */
ValidDate(                         /* Checks for digits and /'s            */
const CHAR *stgDate)               /*  String to check                     */
{
     const CHAR *ptr;

     for (ptr=stgDate; *ptr != '\0'; *ptr++) {
          if (!isdigit(*ptr) && *ptr != '/') {
               return(FALSE);
          }
     }
     return(TRUE);
}

static GBOOL                       /*  TRUE if valid time                  */
ValidTime(                         /* Checks for digits and :'s            */
const CHAR *stgTime)               /*  String to check                     */
{
     const CHAR *ptr;

     for (ptr=stgTime; *ptr != '\0'; *ptr++) {
          if (!isdigit(*ptr) && *ptr != ':') {
               return(FALSE);
          }
     }
     return(TRUE);
}
