/***************************************************************************
 *                                                                         *
 *   GALPARSF.C                                                            *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Utility to search through a a file for a list of files, then          *
 *   call GALPARSE on each of those files with the proper DEFINES.         *
 *                                                                         *
 *                                            - W. Muharsky 07/14/97       *
 *                                                                         *
 ***************************************************************************/
#include "gcomm.h"

#define FILREV "$Revision: 6 $"

#define QUIETOPT    "-Q"           /*  Turns printing off                  */
#define BUILDOPT    "-B"           /*  Turns rebuild on                    */
/***************************************************************************
 * Variable declarations                                                   *
 ***************************************************************************/
static GBOOL Quiet=FALSE;          /*  Print stuff?                        */
static GBOOL Rebuild=FALSE;        /*  Rebuild everything regardless?      */

static CHAR ParseOpts[10000];      /*  Temporary data                      */
static CHAR pcall[10000];          /*  Parse call                          */
static CHAR ftmp[10000];           /*  File temp string                    */

/***************************************************************************
 * Function declarations                                                   *
 ***************************************************************************/
static GBOOL                       /*  TRUE if argument found              */
scanargs(                          /* Scan through arguments for something */
const CHAR *scanfor);              /*  What to scan for                    */

INT
main(VOID);                        /*  Main function                       */

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...);                              /*  Any other arguments                 */

static VOID
ParseFiles(                        /*  Parse from file list                */
CHAR *ListFile);                   /*  File list to parse from             */

/***************************************************************************
 * Source code                                                             *
 ***************************************************************************/
MARKSOURCE(galparsf);              /*  Exported module stub                */

INT
main(VOID)                         /*  Main function                       */
{
     initvid();
     if (_argc >= 3) {
          if (_argc > 3 && scanargs(QUIETOPT)) {
               Quiet=TRUE;
          }
          if (_argc > 3 && scanargs(BUILDOPT)) {
               Rebuild=TRUE;
          }
          ParseFiles(_argv[1]);
     }
     else {
          setatr(0x0C);
          printf("Usage: GALPARSF <ListFile> <temp directory> [-Q] [-B]\n");
          printf("\r");
          printf("     -Q               Queit mode (print nothing)\n");
          printf("     -B               Rebuild everything\n");
          printf("\r");
     }
     clsvid();
     return(0);
}

static VOID
ParseFiles(                        /*  Parse from file list                */
CHAR *ListFile)                    /*  File list to parse from             */
{
     FILE *fp;
     CHAR *wrd;
     struct ffblk fb;
     struct ffblk f2;
     FILE *tmpdat;

     if ((fp=fopen(ListFile,FOPRA)) == NULL) {
          qprintf("Unable to open list file: %s\n",ListFile);
          return;
     }
     if (fgets(ParseOpts,9999,fp) == NULL) {
          qprintf("Unable to read Parse Options\n");
          return;
     }
     if (fgets(ftmp,9999,fp) == NULL) {
          qprintf("Unable to read file list\n");
          return;
     }
     unpad(ParseOpts);
     unpad(ftmp);

     for (wrd=firstwd(ftmp); *wrd != '\0'; wrd=nextwd()) {
          if (fnd1st(&fb,wrd,0)) {
               do {
                    if (!Rebuild && fndfile(&f2,spr("%s\\%s",_argv[2],fb.ff_name),0)) {
                         if (fb.ff_fdate == f2.ff_fdate &&
                          fb.ff_ftime == f2.ff_ftime) {
                              continue;
                         }
                    }
                    setmem(pcall,10000,0);
                    if ((tmpdat=fopen("GALPARSF.TMP",FOPWA)) != NULL) {
                         fprintf(tmpdat,"%s %s\\%s -Q %s",fb.ff_name,
                         _argv[2],fb.ff_name,ParseOpts);
                         fclose(tmpdat);
                    }
                    strcpy(pcall,"GALPARSE @GALPARSF.TMP");
                    qprintf("Calling %s\n",pcall);
                    system(pcall);
                    setFileTm(spr("%s\\%s",_argv[2],fb.ff_name),fb.ff_ftime,
                     fb.ff_fdate);
                    unlink("GALPARSF.TMP");
               } while (fndnxt(&fb));
          }
     }
     fclose(fp);
}

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...)                               /*  Any other arguments                 */
{
     va_list args;

     if (!Quiet) {
          va_start(args,stg);
          vprintf(stg,args);
          va_end(arga);
     }
}

static GBOOL                       /*  TRUE if argument found              */
scanargs(                          /* Scan through arguments for something */
const CHAR *scanfor)               /*  What to scan for                    */
{
     INT count;

     for (count=1; count < _argc; count ++) {
          if (sameas(_argv[count],scanfor)) {
               return(TRUE);
          }
     }
     return(FALSE);
}
