/***************************************************************************
 *                                                                         *
 *   SRCPRP.H                                                              *
 *                                                                         *
 *   Copyright (C) 1996-1997 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is the main header file for the source preparation utility.      *
 *                                                                         *
 *                                           - C. Dunn 3/11/96             *
 *                                                                         *
 ***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define MAXNST 50                  /* maximum number of nests              */
#define MAXTAG 15                  /* maximum number of ifdef tags         */
#define TAGLEN 16                  /* maximum length of ifdef tag          */

                                   /* prpReadLine() return codes           */
#define PROCESS 1                  /*   line read - OK to process (output) */
#define NOTMINE 2                  /*   line read - doesn't belong         */
#define ENDFILE 3                  /*   end of source file reached         */

struct prpblk {                    /* preparation information block        */
     INT nstlvl;                   /*   current nest level                 */
     INT numtags;                  /*   number of tags passed              */
     GBOOL output[MAXNST];         /*   currently outputting to file?      */
     FILE *srcfp;                  /*   source (input) file pointer        */
     FILE *dstfp;                  /*   destination (output) file pointer  */
     CHAR *stags;                  /*   Saved passed in tags               */
     CHAR tags[MAXTAG][TAGLEN];    /*   array of ifdef tags                */
     CHAR inbuf[BUFSIZ];           /*   input buffer for reading file      */
     CHAR srcfil[MAXPATH];         /*   source (input) file name           */
     CHAR dstfil[MAXPATH];         /*   destination (output) file name     */
};

GBOOL
prpFile(                           /* prepare source file for make         */
const CHAR *srcfil,                /*   source (input) file name           */
const CHAR *dstfil,                /*   destination (output) file name     */
CHAR *tags);                       /*   comma-delimited list of tags       */

GBOOL                              /*   returns TRUE on successful init    */
prpInit(                           /* source preparation initialization    */
const CHAR *srcfil,                /*   source (input) file name           */
const CHAR *dstfil,                /*   destination (output) file name     */
CHAR *tags,                        /*   comma-delimited list of tags       */
struct prpblk *prpblk);            /*   preparation information block      */

INT                                /*   return status codes (see above)    */
prpReadLine(                       /* read line from source file           */
struct prpblk *prpblk);            /*   preparation information block      */

CHAR *                             /*   return converted buffer            */
prpXlatEnv(                        /* translate environment variables      */
CHAR *buffer);                     /*   buffer to translate                */

GBOOL                              /*   return TRUE if tag is ours         */
prpCheckTag(                       /* check to see if tag is in our list   */
const CHAR *tag);                  /*   tag to check                       */

GBOOL                              /*   return FALSE if ifdef not endif'ed */
prpShutdown(                       /* source preparation shutdown          */
struct prpblk *prpblk);            /*   preparation information block      */

#ifdef __cplusplus
};
#endif

