/***************************************************************************
 *                                                                         *
 *   CMDARGS.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997       Galacticomm, Inc.  All rights reserved.      *
 *                                                                         *
 *   Searches through _argv for list files and creates its own _argv.      *
 *                                                                         *
 *                                                -W. Munarsky 02/27/98    *
 *                                                                         *
 ***************************************************************************/
#ifndef __CMDARGS_H
#define __CMDARGS_H

class CmdArgs {
public:
     CHAR **argv;
     INT argc;

public:
     CmdArgs::CmdArgs(VOID);            //  Constructor

     CmdArgs::~CmdArgs(VOID);           //  Destructor

     VOID
     CmdArgs::AddArg(                   //  Add an argument
     const CHAR *arg);                  //  Argument to add

     GBOOL                              //  True if file is found
     CmdArgs::AddArgFile(               //  Add an argument file
     const CHAR *FileName);             //  Filename to add

     GBOOL
     CmdArgs::Initialized(VOID);        //  everything initialized?

private:
     CHAR *m_stgarg;                    //  Copy of argument string
     CHAR *m_chars;                     //  Internal buffer of parsed arguments
     INT   m_CharCount;                 //  Character count (for memory alc)
     GBOOL m_Inited;                    //  Everything initialzied

private:
     VOID
     CmdArgs::ParseInput(               //   Parse input buffer for arguments
     const CHAR *pszInput,              // Input buffer to parse
     CHAR **argv,                       // Argument vector which points to args
     CHAR *args,                        // Pointer to argument input string
     INT *iArgCount,                    // Pointer to argument counter
     INT *iCharCount);                  // Pointer to character counter

     VOID
     CmdArgs::Freeargs(VOID);           //  Free up m_argv && m_chars

     VOID
     CmdArgs::Parse(VOID);              //  Parse the m_stgarg string

     GBOOL
     CmdArgs::Setup(VOID);              //  Initialize variables

};

#endif //__CMDARGS_H

