/***************************************************************************
 *                                                                         *
 *   GALMERGE.C                                                            *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Message file merging utility.                                         *
 *                                                                         *
 *                                            - W. Muharsky 07/25/97       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "updutl.h"

#define FILREV "$Revision: 3 $"

INT main(VOID);

INT
main(VOID)
{
     GBOOL Quiet=FALSE;
     struct ffblk fb;

     initvid();
     setatr(0x0B);

     if (_argc != 3 && _argc != 4) {
          printf("Usage: GALMERGE <newfile> <oldfile> [-Q]\n\n");
          printf("     -Q     Quiet mode (don't print anything)\n\n");
          exit(0);
     }
     if (_argc == 4 && sameas(_argv[3],"-Q")) {
          Quiet=TRUE;
     }
     if (!Quiet) {
          printf("\n");
          printf("GALMERGE - Message file merging utility.\n");
          printf("Copyright (c) 1994-1997 Galacticomm, Inc.  ");
          printf("All rights reserved.\n\n");
     }
     if (fndfile(&fb,_argv[2],0)) {
          merge1("GALMERGE.$$$",_argv[1],_argv[2],NULL);
     }
     else {
          copyfile(_argv[1],_argv[2]);
     }
     unlink("GALMERGE.$$$");
     if (!Quiet) {
          printf("DONE");
     }
     clsvid();
     return(0);
}
