/***************************************************************************
 *                                                                         *
 *   GALCOPY.C                                                             *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is a utility to copy files.  It was written because DOS copy     *
 *   and WINDOWS NT copy did not both take the /Y paramater.               *
 *                                                                         *
 *                                                - W. Muharsky 08/04/97   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 3 $"

GBOOL Quiet=FALSE;                 /*  Be quiet about printing things?     */

/***************************************************************************
 *  Function prototypes                                                    *
 ***************************************************************************/
INT
main(VOID);                        /*  Main function                       */

static VOID
CopyFiles(                         /* Copy files                           */
const CHAR *Files,                 /*  Files to copy                       */
const CHAR *To);                   /*  Where to copy to                    */

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...);                              /*  Any other arguments                 */

static GBOOL                       /*  TRUE if we should be quiet          */
GetQuiet(VOID);                    /* Check for quiet option               */

/***************************************************************************
 * Source code                                                             *
 ***************************************************************************/
INT
main(VOID)                         /*  Main function                       */
{
     initvid();
     if (_argc >= 3) {
          Quiet=GetQuiet();
          CopyFiles(_argv[1],_argv[2]);
     }
     else {
          setatr(0x0B);
          printf("\n");
          printf("GALCOPY - Copy file utility.\n");
          printf("Copyright (c) 1995-1997 Galacticomm, Inc.  ");
          printf("All rights reserved.\n\n");
          setatr(0x0C);
          printf("Usage: GALCOPY <from> <to> -Q\n");
          printf("\r");
          printf("     <from>  -Where to copy from (can use wildcards)\n");
          printf("     <to>    -Where to copy to (directory or file)\n");
          printf("     -Q      -Quiet or not?\n");
          printf("\r");
     }
     return(0);
}

static VOID
CopyFiles(                         /* Copy files                           */
const CHAR *Files,                 /*  Files to copy                       */
const CHAR *To)                    /*  Where to copy to                    */
{
     struct ffblk fb;
     GBOOL todir=FALSE;
     CHAR FileTo[GCMAXPTH];
     CHAR FilePath[GCMAXPTH];
     UINT count=0;

     if (fnd1st(&fb,To,FAMDIR) && fb.ff_attrib&FAMDIR) {
          todir=TRUE;
     }
     if (fnd1st(&fb,Files,0)) {
          do {
               fileparts(GCPART_PATH,Files,FilePath,GCMAXPTH);
               stlcat(FilePath,fb.ff_name,GCMAXPTH);
               stlcpy(FileTo,To,GCMAXPTH);
               if (todir) {
                    if (To[strlen(To)-1] != '\\') {
                         stlcat(FileTo,"\\",GCMAXPTH);
                    }
                    stlcat(FileTo,fb.ff_name,GCMAXPTH);
               }
               unlink(FileTo);
               qprintf("Copying file: %s\n",FilePath);
               if (!cpyutl(FilePath,FileTo,FOPRB,FOPWB)) {
                    printf("Error copying file %s!",FilePath);
                    exit(1);
               }
               count++;
          } while (fndnxt(&fb));
     }
     qprintf("%d files copied.\n",count);
}

static VOID
qprintf(                           /*  Quiet checking printf statement     */
CHAR *stg,                         /*  String to print                     */
...)                               /*  Any other arguments                 */
{
     va_list args;

     if (!Quiet) {
          va_start(args,stg);
          vprintf(stg,args);
          va_end(arga);
     }
}

static GBOOL                       /*  TRUE if we should be quiet          */
GetQuiet(VOID)                     /* Check for quiet option               */
{
     INT count;

     for (count=0; count < _argc; count++) {
          if (sameas(_argv[count],"-Q")) {
               return(TRUE);
          }
     }
     return(FALSE);
}
