/***************************************************************************
 *                                                                         *
 *   CVTCHECK.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Conversion template checking program.                                 *
 *                                                                         *
 *                                           - Wally Muharsky 10/20/97     *
 *                                                                         *
 ***************************************************************************/
#include "gcomm.h"
#include "dfcverif.h"

VOID
main(VOID);

static VOID
CheckTemplate(                     /*  Check the conversion template       */
const CHAR *File);                 /*  File to check                       */

VOID
main(VOID)
{
     initvid();

     setatr(0x0B);
     printf("\n");
     printf("CVTCHECK - Conversion file template checker.\n");
     printf("Copyright (c) 1994-1997 Galacticomm, Inc.  ");
     printf("All rights reserved.\n\n");

     if (_argc == 2) {
          CheckTemplate(_argv[1]);
     }
     else {
          setatr(0x0C);
          printf("Usage: CVTCHECK <file>\n");
          printf("\r");
     }
     clsvid();
}

static VOID
CheckTemplate(                     /*  Check the conversion template       */
const CHAR *File)                  /*  File to check                       */
{
     INT ans;

     if ((ans=dfcVerifyFile(File)) == DFC_SUCCESS) {
          setatr(0x0B);
          printf("Conversion template ok.\n");
     }
     else {
          setatr(0x0B);
          printf("\7Conversion template error (line %d):\n",LinesRead);
          setatr(0x0C);
          printf("%s\n",dfcErrorStg(ans));
          if (strlen(dfcbuf) > 0) {
               printf("\n%s\n",dfcbuf);
          }
     }
}

