/***************************************************************************
 *                                                                         *
 *   GALDBGCG.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Offline utility to configure CodeGuard under NT/95.                   *
 *                                                                         *
 *                                        - Don Pitchford    11/15/96      *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "excphand.h"

#define FILREV "$Revision: 5 $"

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048],cgiFile[2048];
     CHAR *setval;

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          sprintf(cgiFile,"%s\\wgserver.cgi",path);
          *pTmp='\\';
     }
     switch (MessageBox(
             NULL,
             "Do you want to enable CodeGuard debugging?\n\n"
               "Enabling CodeGuard debugging slows your system, but creates a "
               "log file and records many (even insignificant) errors.",
             "Enable CodeGuard?",
             MB_ICONQUESTION|MB_YESNO|MB_TASKMODAL|MB_SETFOREGROUND)) {
     case IDYES:
          setval="yes";
          break;
     default:
     case IDNO:
          setval="no";
     }
     WritePrivateProfileString("Options","CodeGuard",setval,cgiFile);
     return(0);
EXCEPT
     return(1);
}
